/*!
 * @file base_object.h
 * @brief Definition of the BaseObject class.
 *
 * This is a global handler for all classes Object and Class names
 *
 * BaseObject is the class, that handles object registration and
 * is the only write-access member of ClassList, where the Objects
 * References are stored.
 */


#ifndef __BASE_OBJECT_H_
#define __BASE_OBJECT_H_

#include "class_id.h"
#include <string>

class TiXmlNode;
class TiXmlElement;
class ClassList;

//! A class all other classes are derived from
class BaseObject
{

public:
  BaseObject (const std::string& objectName = "");

  virtual ~BaseObject ();

  virtual void loadParams(const TiXmlElement* root);
  void setName (const std::string& newName);
  /** returns the Name of this Object */
  inline const char* getName ()const { return this->objectName.c_str(); };
  /** @returns the XML-Element with whicht this Object was loaded */
  inline TiXmlNode* getXmlElem() const { return this->xmlElem; };

  /** @returns the className of the corresponding Object */
  inline const char* getClassName() const { return this->className.c_str(); };
  /** @returns the classID of the corresponding Object */
  inline int getClassID() const { return this->classID; };
  const ClassID& getLeafClassID() const;

  bool isA (ClassID classID) const;
  bool isA (const std::string& className) const;

  /** @param classID comparer for a ClassID @returns true on match, false otherwise */
  bool operator==(ClassID classID) const  { return this->isA(classID); };
  bool operator==(const std::string& objectName) const;

protected:
  void setClassID(ClassID classID, const std::string& className);

protected:
  std::string        objectName;       //!< The name of this object

private:
  std::string        className;        //!< the name of the class
  long               classID;          //!< this is the id from the class_id.h enumeration
  ClassID            leafClassID;      //!< The Leaf Class ID

  ClassList*         classList;        //!< Pointer to the ClassList this Object is inside of

  TiXmlNode*         xmlElem;          //!< The XML Element with wich this Object was loaded(saved).
};

#endif /* __BASE_OBJECT_H_ */
