/*!
 * @file proxy_settings.h
 *  some shared data from the proxy settings
 */

#ifndef _PROXY_SETTINGS_H
#define _PROXY_SETTINGS_H

#include "base_object.h"
#include "netdefs.h"

#include <vector>


class NetworkStream;
class Synchronizeable;
class TiXmlElement;


/* and here is the class itsself*/
class ProxySettings : public BaseObject
{

  public:
    inline static ProxySettings* getInstance() { if (!ProxySettings::singletonRef) ProxySettings::singletonRef = new ProxySettings();
      return ProxySettings::singletonRef; }
    virtual ~ProxySettings();

    void loadProxySettings(const TiXmlElement* root);

    /** @param number: sets the max number of players */
    inline void setMaxPlayer(int number) { this->maxPlayer = number; }
    /** @returns teh max number of players */
    int getMaxPlayer() { return this->maxPlayer; }
    void setProxyAddr(const std::string& proxyAddr);

    /** @returns the list of proxy servers from the init file */
    inline std::vector<IPaddress*>* getProxyList() { return &this->proxies; }


  private:
    ProxySettings();


  private:

    static ProxySettings*       singletonRef;            //!< Pointer to the only instance of this Class

    int                         maxPlayer;               //!< maximal number of players

    std::vector<IPaddress*>      proxies;                 //!< all registered proxies

};



#endif /* _PROXY_SETTINGS_H */
