
/*!
 * @file ip.h
 *
 * @brief the ip class is used to transform strings to ip's and backwards
 * it can also be used to
 *
 */

#ifndef __IP_H__
#define __IP_H__

#include <string>

#include "netdefs.h"


//! A class to handle time itself
class IP
{
  public:
    /// CONSTRUCTORS
    IP();
    IP(const std::string& ip, int port = -1, bool resolve = true);
    IP(int ip, int port);
    IP(const IPaddress& ip);
    IP(const IP& ip);

    /// OPERATORS
    const IP& operator=(const IP& ip);
    bool operator==(const IP& ip);

    /// RETRIEAL
    /** @returns the IP */
    int ip() const { return this->_ip; };
    /** @returns the Port */
    short port() const { return this->_port; };

    int ipPart(unsigned int part) const;
    std::string ipString() const;

  public:

    /// SETUP
    static IP stringToIP(const std::string& ip, int port = -1, bool resolve = true);


    static std::string ipToString(const IPaddress& ipaddr);
    static std::string ipToString(int ip, int port = -1);

  private:
    int           _ip;    //!< The IP in int form.
    short         _port;  //!< The Port number of the IP

};

#endif /* __IP_H__ */
