/*!
 * @file network_monitor.h
 *  a class to monitor the network: throughput, network nodes
 */

#ifndef _NETWORK_MONITOR_H
#define _NETWORK_MONITOR_H

#include "base_object.h"
#include "synchronizeable.h"

#include <list>

class NetworkStream;
class PeerInfo;


class NetworkMonitor : public Synchronizeable
{

  public:
    NetworkMonitor(NetworkStream* networkStream);
    virtual ~NetworkMonitor();


    void addClient(PeerInfo* node);
    void addProxyServer(PeerInfo* node);
    void addMasterServer(PeerInfor* node);

    void removeClient(PeerInfor* node);
    void removeProxyServer(PeerInfor* node);
    void removeMasterServer(PeerInfor* node);


    void process();


  private:
    std::list<PeerInfo*>         clientList;                   //!< list of all clients in the network
    std::list<PeerInfo*>         proxyServerList;              //!< list of all proxy servers in the network
    std::list<PeerInfo*>         masterServerList;             //!< list of all master servers in the network (should be 1!! :D)
};


#endif
