/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#include "glgui.h"
#include "shell_command.h"

#include "network_stream.h"

#include "network_monitor.h"

// SHELL_COMMAND(gui, MappedWater, toggleGui);
// SHELL_COMMAND(output, MappedWater, saveParams);



/**
 * starts a network monitor
 */
NetworkMonitor::NetworkMonitor(NetworkStream* networkStream)
{

}


/**
 * deconstructor
 */
NetworkMonitor::~NetworkMonitor()
{}






#if 0
  if (this->box == NULL)
{
  this->box = new OrxGui::GLGuiBox(OrxGui::Vertical);
  {
    OrxGui::GLGuiBox* waterColorBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* waterColorText = new OrxGui::GLGuiText();
      waterColorText->setText("WaterColor");
      waterColorBox->pack(waterColorText);

      OrxGui::GLGuiSlider* waterColorR = new OrxGui::GLGuiSlider();
      waterColorR->setRange(0, 1.0f);
      waterColorR->setValue(this->waterColor.x);
      waterColorR->setStep(0.1f);
      waterColorR->connect(SIGNAL(waterColorR, valueChanged), this, SLOT(MappedWater, resetWaterColorR));
      waterColorBox->pack(waterColorR);

      OrxGui::GLGuiSlider* waterColorG = new OrxGui::GLGuiSlider();
      waterColorG->setRange(0, 1.0f);
      waterColorG->setStep(0.1f);
      waterColorG->setValue(this->waterColor.y);
      waterColorG->connect(SIGNAL(waterColorG, valueChanged), this, SLOT(MappedWater, resetWaterColorG));
      waterColorBox->pack(waterColorG);

      OrxGui::GLGuiSlider* waterColorB = new OrxGui::GLGuiSlider();
      waterColorB->setRange(0, 1.0f);
      waterColorB->setStep(0.1f);
      waterColorB->setValue(this->waterColor.z);
      waterColorB->connect(SIGNAL(waterColorB, valueChanged), this, SLOT(MappedWater, resetWaterColorB));
      waterColorBox->pack(waterColorB);
    }
    this->box->pack(waterColorBox);

    OrxGui::GLGuiBox* waterUVBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* waterUVText = new OrxGui::GLGuiText();
      waterUVText->setText("WaterUV");
      waterUVBox->pack(waterUVText);

      OrxGui::GLGuiSlider* waterUV = new OrxGui::GLGuiSlider();
      waterUV->setRange(1, 20);
      waterUV->setValue(this->waterUV);
      waterUV->setStep(1);
      waterUV->connect(SIGNAL(waterUV, valueChanged), this, SLOT(MappedWater, setWaterUV));
      waterUVBox->pack(waterUV);
    }
    this->box->pack(waterUVBox);

    OrxGui::GLGuiBox* waterFlowBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* waterFlowText = new OrxGui::GLGuiText();
      waterFlowText->setText("WaterFlow");
      waterFlowBox->pack(waterFlowText);

      OrxGui::GLGuiSlider* waterFlow = new OrxGui::GLGuiSlider();
      waterFlow->setRange(0.01f, 2);
      waterFlow->setValue(this->waterFlow);
      waterFlow->setStep(0.02f);
      waterFlow->connect(SIGNAL(waterFlow, valueChanged), this, SLOT(MappedWater, setWaterFlow));
      waterFlowBox->pack(waterFlow);
    }
    this->box->pack(waterFlowBox);

    OrxGui::GLGuiBox* shineSizeBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* shineSizeText = new OrxGui::GLGuiText();
      shineSizeText->setText("ShineSize");
      shineSizeBox->pack(shineSizeText);

      OrxGui::GLGuiSlider* shineSize = new OrxGui::GLGuiSlider();
      shineSize->setRange(1, 128);
      shineSize->setValue(this->shineSize);
      shineSize->setStep(1);
      shineSize->connect(SIGNAL(shineSize, valueChanged), this, SLOT(MappedWater, resetShineSize));
      shineSizeBox->pack(shineSize);
    }
    this->box->pack(shineSizeBox);

    OrxGui::GLGuiBox* shineStrengthBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* shineStrengthText = new OrxGui::GLGuiText();
      shineStrengthText->setText("ShineStrength");
      shineStrengthBox->pack(shineStrengthText);

      OrxGui::GLGuiSlider* shineStrength = new OrxGui::GLGuiSlider();
      shineStrength->setRange(0, 1);
      shineStrength->setValue(this->shineStrength);
      shineStrength->setStep(0.1f);
      shineStrength->connect(SIGNAL(shineStrength, valueChanged), this, SLOT(MappedWater, resetShineStrength));
      shineStrengthBox->pack(shineStrength);
    }
    this->box->pack(shineStrengthBox);

    OrxGui::GLGuiBox* reflStrengthBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* reflStrengthText = new OrxGui::GLGuiText();
      reflStrengthText->setText("ReflStrength");
      reflStrengthBox->pack(reflStrengthText);

      OrxGui::GLGuiSlider* reflStrength = new OrxGui::GLGuiSlider();
      reflStrength->setRange(0, 1);
      reflStrength->setValue(this->reflStrength);
      reflStrength->setStep(0.1f);
      reflStrength->connect(SIGNAL(reflStrength, valueChanged), this, SLOT(MappedWater, resetReflStrength));
      reflStrengthBox->pack(reflStrength);
    }
    this->box->pack(reflStrengthBox);

    OrxGui::GLGuiBox* refractionBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* refractionText = new OrxGui::GLGuiText();
      refractionText->setText("Refraction");
      refractionBox->pack(refractionText);

      OrxGui::GLGuiSlider* refraction = new OrxGui::GLGuiSlider();
      refraction->setRange(0.001f, 0.1f);
      refraction->setValue(this->refraction);
      refraction->setStep(0.004f);
      refraction->connect(SIGNAL(refraction, valueChanged), this, SLOT(MappedWater, resetRefraction));
      refractionBox->pack(refraction);
    }
    this->box->pack(refractionBox);

    OrxGui::GLGuiBox* lightPosBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* lightPosText = new OrxGui::GLGuiText();
      lightPosText->setText("LightPos");
      lightPosBox->pack(lightPosText);

      OrxGui::GLGuiSlider* lightPosX = new OrxGui::GLGuiSlider();
      lightPosX->setRange(-4000, 4000);
      lightPosX->setValue(this->lightPos.x);
      lightPosX->setStep(15);
      lightPosX->connect(SIGNAL(lightPosX, valueChanged), this, SLOT(MappedWater, resetLightPosX));
      lightPosBox->pack(lightPosX);

      OrxGui::GLGuiSlider* lightPosY = new OrxGui::GLGuiSlider();
      lightPosY->setRange(-4000, 4000);
      lightPosY->setStep(15);
      lightPosY->setValue(this->lightPos.y);
      lightPosY->connect(SIGNAL(lightPosY, valueChanged), this, SLOT(MappedWater, resetLightPosY));
      lightPosBox->pack(lightPosY);

      OrxGui::GLGuiSlider* lightPosZ = new OrxGui::GLGuiSlider();
      lightPosZ->setRange(-4000, 4000);
      lightPosZ->setStep(15);
      lightPosZ->setValue(this->lightPos.z);
      lightPosZ->connect(SIGNAL(lightPosZ, valueChanged), this, SLOT(MappedWater, resetLightPosZ));
      lightPosBox->pack(lightPosZ);
    }
    this->box->pack(lightPosBox);

    OrxGui::GLGuiBox* waterHeightBox = new OrxGui::GLGuiBox(OrxGui::Horizontal);
    {
      OrxGui::GLGuiText* waterHeightText = new OrxGui::GLGuiText();
      waterHeightText->setText("WaterHeight");
      waterHeightBox->pack(waterHeightText);

      OrxGui::GLGuiSlider* waterHeight = new OrxGui::GLGuiSlider();
      waterHeight->setRange(100, 370);
      waterHeight->setValue(this->waterHeight);
      waterHeight->setStep(4);
      waterHeight->connect(SIGNAL(waterHeight, valueChanged), this, SLOT(MappedWater, setWaterHeight));
      waterHeightBox->pack(waterHeight);
    }
    this->box->pack(waterHeightBox);
  }

  this->box->showAll();
  this->box->setAbsCoor2D(300, 40);
  OrxGui::GLGuiHandler::getInstance()->activate();
  OrxGui::GLGuiHandler::getInstance()->activateCursor();
}
  else
{
  OrxGui::GLGuiHandler::getInstance()->deactivate();
  OrxGui::GLGuiHandler::getInstance()->deactivateCursor();
  delete this->box;
  this->box = NULL;
}
#endif
