/*!
 * @file udp_server_socket.h
 *  waits for incoming connections

 */

#ifndef _UDP_SERVER_SOCKET
#define _UDP_SERVER_SOCKET

/* include this file, it contains some default definitions */
#include "netdefs.h"


/* include base_object.h since all classes are derived from this one */
#include "base_object.h"
#include "server_socket.h"
#include "udp_socket.h"

#include <list>
#include <vector>

#define UDP_PACKET_SIZE 10240
#define MAX_NEW_CONNECTIONS 8

struct NetworkPacket
{
  int length;
  byte * data;
};

typedef std::list<NetworkPacket> NetworkPacketList;

typedef std::vector<NetworkPacketList> PacketBuffer;

struct UserInfo
{
  IPaddress addr;
  byte randomByte;
};

typedef std::vector<UserInfo> UserList;

typedef std::list<UdpSocket*> UdpSocketList;

class UdpServerSocket : public ServerSocket
{
  public:
    UdpServerSocket( int port);
    virtual ~UdpServerSocket();

    virtual bool listen( unsigned int port );

    virtual NetworkSocket* getNewSocket( void );

    virtual void close();

    virtual void update();

    void removeUserPackets( int userId );
    void removeUser( int userId );
    NetworkPacket getPacket( int userId );
    bool sendPacket( NetworkPacket networkPacket, int userId );
    int getPacketCount( int childId );
    void initUser( int childId, IPaddress ip, byte randomByte );

  private:
    UDPsocket     socket;           //!< will be uses to send/recieve data
    UDPpacket *   packet;           //!< packet structure to recieve packet
    PacketBuffer  packetBuffer;     //!< will store recieved packets for UdpSockets
    UserList      userList;         //!< contains information about clients
    UdpSocketList newSocketList;    //!< contains new socket

};

#endif
