/*!
 * @file scrip.h
 *  wrapper for a lua_State
 */

#ifndef _SCRIPT_H
#define _SCRIPT_H


#include "base_object.h"

#include <list>

struct lua_State;

struct WorldObject
{
  std::string name;
  std::string type;
};

class Script : public BaseObject
{
  public:
    Script(const TiXmlElement* root = NULL);
    Script(const std::string& filename);
    ~Script();

    /// LOADING
    void loadParams(const TiXmlElement* root);

    void loadFileNoRet(const std::string& filename) { loadFile(filename); };
    bool loadFile(const std::string& filename);
    void addObject( const std::string& className,const std::string& objectName);
    void registerClass(const std::string& className);                           //!< Register a class but dont add any instances 

    /// QUERRYING
    /** @returns fileName */
    std::string getFileName() { return currentFile; }
    lua_State* getLuaState() const { return luaState; }



    /// EXECUTING
    // first select function
    bool selectFunction(const std::string& functionName, int retCount);

    // push parameters for luafunction
    bool  pushParam(int param, std::string& toFunction);
    bool  pushParam(float param, std::string& toFunction);
    bool  pushParam(double param, std::string& toFunction);

    // Execute the Function
    bool executeFunction();

     // get returned values in the order the lua function returns it
    int   getReturnedInt();
    bool  getReturnedBool();
    float getReturnedFloat();
    void  getReturnedString(std::string& string);

    bool executeFile();

  private:
    void addThisScript();
    int  reportError(int error);                      //!< Get errormessage from the lua stack and print it.
    bool registerStandartClasses();                   //!< Register all the classes that the script might need
    bool classIsRegistered(const std::string& type);  //!< Checks wheter the class "type" has already been registered with the script
    bool objectIsAdded(const std::string& name);      //!< Checks wheter the object "name" has already been added to the script

    lua_State*              luaState;                //!< The lua_State that the Script works on
    std::string             currentFile;             //!< The file that is loaded in the script
    std::string             currentFunction;         //!< The name of the current active function (the one that gets the pushed parameter)
    int                     argumentCount;           //!< Number of arguments for the current function
    int                     returnCount;             //!< Number of return values of the current function

    std::list<WorldObject>  registeredObjects;       //!< The list of all the objects and their type that have been registered with this script



};
#endif /* _SCRIPT_H */
