/*!
    \projectile.h
  *  a projectile, that is been shooted by a weapon
*/

#ifndef _TEST_BULLET_H
#define _TEST_BULLET_H

#include "projectile.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class TestBullet : public Projectile
{
  public:
    TestBullet ();
    virtual ~TestBullet ();


    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;

  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           trailParticles;
    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;


    WorldEntity* hitEntity; // FIXME TEMPORARY

};

#endif /* _TEST_BULLET_H */
