/*!
 * @file rocket.h
 * @brief a Rocket Projectile
*/

#ifndef _ROCKET_H
#define _ROCKET_H

#include "projectile.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class Rocket : public Projectile
{
  public:
    Rocket ();
    virtual ~Rocket ();


    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           trailParticles;
    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;


    WorldEntity* hitEntity; // FIXME TEMPORARY

};

#endif /* _ROCKET_H */
