/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "rail_projectile.h"

#include "state.h"
#include "class_list.h"
#include "model.h"

#include "dot_emitter.h"
#include "sprite_particles.h"

#include <cassert>
#include "debug.h"

using namespace std;

CREATE_FAST_FACTORY_STATIC(RailProjectile, CL_RAIL_PROJECTILE);

/**
 *  standard constructor
*/
RailProjectile::RailProjectile () : Projectile()
{
  this->setClassID(CL_RAIL_PROJECTILE, "RailProjectile");

  this->loadModel("models/projectiles/laser_projectile.obj", 100);

  this->setMinEnergy(10);
  this->setHealthMax(10);
  this->lifeSpan = .5f;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
  this->emitter->setEmissionRate(300.0);
  this->emitter->setEmissionVelocity(50.0);
}


/**
 *  standard deconstructor
*/
RailProjectile::~RailProjectile ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (RailProjectile::explosionParticles != NULL && ClassList::getList(CL_RAIL_PROJECTILE)->size() <= 1)
  {
    //if (ClassList::exists(RailProjectile::explosionParticles, CL_PARTICLE_SYSTEM))
    //  delete RailProjectile::explosionParticles;
    PRINTF(1)("Deleting RailProjectile Particles\n");
    RailProjectile::explosionParticles = NULL;
  }

}

SpriteParticles* RailProjectile::explosionParticles = NULL;

void RailProjectile::activate()
{
  if (unlikely(RailProjectile::explosionParticles == NULL))
  {
    RailProjectile::explosionParticles = new SpriteParticles(1000);
    RailProjectile::explosionParticles->setName("RailProjectileExplosionParticles");
    RailProjectile::explosionParticles->setLifeSpan(.5, .3);
    RailProjectile::explosionParticles->setRadius(0.0, 10.0);
    RailProjectile::explosionParticles->setRadius(.5, 6.0);
    RailProjectile::explosionParticles->setRadius(1.0, 3.0);
    RailProjectile::explosionParticles->setColor(0.0, 1,1,0,.9);
    RailProjectile::explosionParticles->setColor(0.5, .8,.8,0,.5);
    RailProjectile::explosionParticles->setColor(1.0, .8,.8,.7,.0);
  }

  this->setHealth(10);
}


void RailProjectile::deactivate()
{
  assert (RailProjectile::explosionParticles != NULL);
  RailProjectile::explosionParticles->removeEmitter(this->emitter);
  this->lifeCycle = 0.0;

  this->toList(OM_NULL);
  this->removeNode();
  RailProjectile::fastFactory->kill(this);
}


void RailProjectile::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity && entity->isA(CL_NPC))
    this->destroy( entity );
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param dt time since last tick
*/
void RailProjectile::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * dt;
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->deactivate();
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void RailProjectile::destroy (WorldEntity* killer)
{
  Projectile::destroy( killer );
  PRINTF(5)("DESTROY RailProjectile\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.

  this->emitter->setSystem(RailProjectile::explosionParticles);
}


void RailProjectile::draw () const
{
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_LIGHTING);

  WorldEntity::draw();
/*  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();
  glPopMatrix();*/

  glPopAttrib();
}

