

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "projectile.h"

#include "world_entity.h"
#include "world_entities/weapons/weapon.h"
#include "model.h"
#include "util/loading/resource_manager.h"

#include "debug.h"


/**
 *  standard constructor
*/
Projectile::Projectile () : WorldEntity()
{
  this->setClassID(CL_PROJECTILE, "Projectile");

  this->lifeCycle = 0.0;
  this->lifeSpan = 1.0f; /* sec */
  this->target = NULL;
  this->removeNode();

  /* character attributes */
  this->setHealth(1.0f);
  this->setDamage(1.0f); // default damage of a projectile set to 100.0 damage points

  this->explosionBuffer = NULL;
  this->engineBuffer = NULL;
}


/**
 *  standard deconstructor
*/
Projectile::~Projectile ()
{
  if (this->explosionBuffer != NULL)
    ResourceManager::getInstance()->unload(this->explosionBuffer);
  if (this->engineBuffer != NULL)
    ResourceManager::getInstance()->unload(this->engineBuffer);
  /*
     do not delete the test projectModel, since it is pnode
     and will be cleaned out by world
  */
  //delete this->projectileModel;
}


void Projectile::loadExplosionSound(const std::string& explosionSound)
{
  if (this->explosionBuffer != NULL)
    ResourceManager::getInstance()->unload(this->explosionBuffer);

  else if (!explosionSound.empty())
  {
    this->explosionBuffer = (OrxSound::SoundBuffer*)ResourceManager::getInstance()->load(explosionSound, WAV);
    if (this->explosionBuffer != NULL)
    {
      PRINTF(4)("Loaded sound %s to Pickup: %s.\n", explosionSound.c_str(), this->getName());
    }
    else
    {
      PRINTF(2)("Failed to load sound %s to explosion %s.\n.", explosionSound.c_str(), this->getName());
    }
  }
  else
    this->explosionBuffer = NULL;
}


void Projectile::loadEngineSound(const std::string& engineSound)
{
  if (this->engineBuffer != NULL)
    ResourceManager::getInstance()->unload(this->engineBuffer);

  else if (!engineSound.empty())
  {
    this->engineBuffer = (OrxSound::SoundBuffer*)ResourceManager::getInstance()->load(engineSound, WAV);
    if (this->engineBuffer != NULL)
    {
      PRINTF(4)("Loaded sound %s to Pickup: %s.\n", engineSound.c_str(), this->getName());
    }
    else
    {
      PRINTF(2)("Failed to load sound %s to engine %s.\n.", engineSound.c_str(), this->getName());
    }
  }
  else
    this->engineBuffer = NULL;
}


void Projectile::setMinEnergy(float energyMin)
{
  this->energyMin = energyMin;
}


/**
 *  this sets the flight direction of the projectile
 * @param directin in which to flight

   this function will calculate a vector out of this to be used in the
   tick function
*/
void Projectile::setFlightDirection(const Quaternion& flightDirection)
{
  Vector v(1, 0, 0);
  this->flightDirection = flightDirection.apply(v);
  this->flightDirection.normalize();
}

/**
 *  sets the velocity vector to a spec speed
 * @param velocity: vector of the velocity
*/
void Projectile::setVelocity(const Vector &velocity)
{
  //Vector offsetVel =
  this->velocity = velocity;
 // offsetVel.normalize();
  //this->velocity += (offsetVel * 50.0);
}



void Projectile::setTarget(PNode* target)
{
  if (this->target == NULL)
    this->target = new PNode(target, PNODE_PARENT_MODE_DEFAULT | PNODE_REPARENT_ON_PARENTS_REMOVE);
  else
    this->target->setParent(target);
}


/**
 * signal tick, time dependent things will be handled here
 * @param dt since last tick
*/
void Projectile::tick (float dt)
{
  Vector v = this->velocity * (dt);
  this->shiftCoor(v);

  if (this->tickLifeCycle(dt))
    this->destroy( NULL );
}


/**
 *  the function gets called, when the projectile is destroyed
*/
void Projectile::destroy (WorldEntity* killer)
{
  if (this->explosionBuffer != NULL)
    this->soundSource.play(this->explosionBuffer);
}

