/*!
 * @file laser.h
 * @brief a projectile, that is been shooted by a weapon
*/

#ifndef _LASER_H
#define _LASER_H

#include "projectile.h"

class Vector;
class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;

class Laser : public Projectile
{
  public:
    Laser ();
    virtual ~Laser ();


    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float dt);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;

    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;


    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _LASER_H */
