/*!
 * @file hyperblast.h
 * @brief a Hyperblast Projectile
*/

#ifndef _HYPERBLAST_H
#define _HYPERBLAST_H

#include "projectile.h"

class Vector;
class Weapon;
class SparkParticles;
class ParticleEmitter;
class FastFactory;

class Hyperblast : public Projectile
{
  public:
    Hyperblast ();
    virtual ~Hyperblast ();


    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;
    static SparkParticles*            explosionParticles;

    ParticleEmitter*                  emitter;
    float                             size;

    WorldEntity* hitEntity; // FIXME TEMPORARY
};

#endif /* _HYPERBLAST_H */
