/*!
 * @file guided_missile.h
 * @brief a GuidedMissile Projectile
*/

#ifndef _GUIDED_MISSILE_H
#define _GUIDED_MISSILE_H

#include "projectile.h"

class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;
class Aim;

class GuidedMissile : public Projectile
{
  public:
    GuidedMissile ();
    virtual ~GuidedMissile ();

    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           trailParticles;
    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;
    float                             agility;
    float                             maxVelocity;
    float                             speed;
    Vector                            diffVector ;
    Vector                            correctionVector;

    WorldEntity* hitEntity; // FIXME TEMPORARY

};

#endif /* _GUIDED_MISSILE_H */
