/*!
 * @file boomerang_projectile.h
 * @brief a BoomerangProjectile Projectile
*/

#ifndef _BOOMERANG_PROJECTILE_H
#define _BOOMERANG_PROJECTILE_H

#include "projectile.h"

class Weapon;
class SpriteParticles;
class ParticleEmitter;
class FastFactory;
class Aim;

class BoomerangProjectile : public Projectile
{
  public:
    BoomerangProjectile ();
    virtual ~BoomerangProjectile ();

    virtual void activate();
    virtual void deactivate();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);

    virtual void destroy (WorldEntity* killer);

    virtual void tick (float time);
    virtual void draw () const;


  private:
    static FastFactory*               fastFactory;
    static SpriteParticles*           trailParticles;
    static SpriteParticles*           explosionParticles;

    ParticleEmitter*                  emitter;
    float                             agility;
    float                             maxVelocity;
    float                             speed;
    Vector                            diffVector ;
    Vector                            correctionVector;

    WorldEntity* hitEntity; // FIXME TEMPORARY

};

#endif /* _BOOMERANG_PROJECTILE_H */
