/*!
 * @file network_stream.h
 *  implementation of a network pipe
 */

#ifndef _HANDSHAKE
#define _HANDSHAKE

#include "base_object.h"
#include "synchronizeable.h"

#define _ORXONOX_ID 0xF91337A0

#define _ORXONOX_VERSION 1

struct HandshakeState {
  int orxId;
  int version;
  
  int networkManagerId;
  int messageManagerId;
  int hostId;
  
  int completed;
  int canDel;
  
  int error;
  
  std::string errorString;
  
  //additional data
  std::string preferedNickName;
};

class Handshake : public Synchronizeable
{
  public:
    Handshake( bool server, int clientId = 0, int networkGameManagerId = 0, int messageManagerId = 0 );
    inline bool       completed(){ return localState.completed != 0 && remoteState.completed != 0; }
    inline bool       ok(){ return localState.error == 0 && remoteState.error == 0; }
    inline int        getHostId(){ return remoteState.hostId; }
    inline int        getNetworkGameManagerId(){ return remoteState.networkManagerId; }
    inline int        getMessageManagerId(){ return remoteState.messageManagerId; }
    inline void       doReject( std::string reason ){ localState.error = 1; localState.errorString = "the server rejected your connection ["+ reason +"]"; }
    inline bool       canDel(){ return localState.canDel == 1 && remoteState.canDel == 1; }
    inline bool       allowDel(){ return localState.canDel == 1; }
    inline void       del(){ localState.canDel = 1; }
    
    inline void       setPreferedNickName( const std::string & nick ){ localState.preferedNickName = nick; }
    inline std::string getPreferedNickName(){ return remoteState.preferedNickName; }
    
    virtual void varChangeHandler( std::list<int> & id );

  private:
    HandshakeState localState;
    HandshakeState remoteState;
    
    int netManId_handler;
    int msgManId_handler;
    int hostId_handler;
    int completed_handler;
    int error_handler;
    int errorString_handler;
    int orxId_handler;
    int version_handler;
    int candel_id;

};


#endif
