/**
 * @file fog_effect.h
 * Generates simple openGL fog
*/

#ifndef _FOG_EFFECT
#define _FOG_EFFECT

#include "weather_effect.h"
#include "glincl.h"
#include "vector.h"

class CloudEffect;

class FogEffect : public WeatherEffect
{
public:
  FogEffect(const TiXmlElement* root = NULL);
  virtual ~FogEffect();

  virtual void loadParams(const TiXmlElement* root);

  virtual void init();

  virtual void activate();
  virtual void deactivate();

  void activateFog()
  {
    this->activate();
  }

  void deactivateFog()
  {
    this->deactivate();
  }

  virtual void draw() const;
  virtual void tick(float dt);

  inline void setFogMode(const std::string& mode)
  {
    this->fogMode = this->stringToFogMode(mode);
  }

  inline void setFogDensity(float density)
  {
    this->fogDensity = density;
  }

  inline void setFogRange(float start, float end)
  {
    this->fogStart = start;
    this->fogEnd = end;
  }

  inline void setFogColor(float r, float g, float b)
  {
    this->colorVector = Vector(r, g, b);
  }

  inline void setFogFadeIn(float fadein)
  {
    this->fogFadeInDuration = fadein;
  }

  inline void setFogFadeOut(float fadeout)
  {
    this->fogFadeOutDuration = fadeout;
  }

  inline void setFogOption(const std::string& option)
  {
    if (option == "activate")
      this->fogActivate = true;
  }
  
  inline void setCloudColor(float colorX, float colorY, float colorZ)
  {
    this->cloudColor = Vector(colorX, colorY, colorZ);
  }
  inline void setSkyColor(float colorX, float colorY, float colorZ)
  {
    this->skyColor = Vector(colorX, colorY, colorZ);
  }

  void fadeInFog();
  void fadeOutFog();


private:
  inline GLint stringToFogMode(const std::string& mode)
  {
    if(mode == "GL_LINEAR")
      return GL_LINEAR;
    else if(mode == "GL_EXP")
      return GL_EXP;
    else if(mode == "GL_EXP2" )
      return GL_EXP2;
    else
      return -1;
  }

  bool          fogActivate;

  bool          fogFadeInActivate;
  bool          fogFadeOutActivate;

  GLfloat       fogFadeInDuration;
  GLfloat       fogFadeOutDuration;

  GLint         fogMode;
  GLfloat       fogDensity;
  GLfloat       fogFadeDensity;

  GLfloat       fogStart;
  GLfloat       fogEnd;
  GLfloat       fogFadeEnd;

  Vector        colorVector;
  float         localTimer; 
  
  Vector oldSkyColor;
  Vector oldCloudColor;
  Vector skyColor;
  Vector cloudColor;
};

#endif  /* _FOG_EFFECT */
