

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "attractor_mine.h"


#include "shader.h"
#include "state.h"
#include "debug.h"

#include "loading/factory.h"
#include "loading/load_param.h"

#include "effects/explosion.h"

CREATE_FACTORY(AttractorMine, CL_ATTRACTOR_MINE);


AttractorMine::AttractorMine(const TiXmlElement* root)
  : NPC(NULL)
{
  this->setClassID(CL_ATTRACTOR_MINE, "AttractorMine");

  if ((float)rand()/RAND_MAX > .5f)
    this->loadModel("models/ships/bolido.obj", 6);
  else
    this->loadModel("models/ships/gobblin.obj", 6);




  this->shader = NULL;
  if (likely(Shader::checkShaderAbility()))
    this->shader = Shader::getShader("shaders/toon.vert", "shaders/toon.frag");

  this->randomRotAxis = VECTOR_RAND(1);

  if (root != NULL)
    this->loadParams(root);
}


AttractorMine::~AttractorMine ()
{
  if (this->shader)
    Shader::unload(this->shader);
}


void AttractorMine::loadParams(const TiXmlElement* root)
{
  NPC::loadParams(root);

}


void AttractorMine::destroy(WorldEntity* killer)
{
  Explosion::explode(this, Vector(10,10,10));
  this->toList(OM_DEAD);

}



/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
 */
void AttractorMine::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];

  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);

//   if (this->shader != NULL && this->shader != Shader::getActiveShader())
//     shader->activateShader();

  this->getModel()->draw();
//   shader->deactivateShader();


/*  if (this->model)
    this->model->draw();*/
  glPopMatrix();
}


void AttractorMine::tick(float dt)
{
//  Vector direction = (State::getCameraTarget()->getAbsCoor() - this->getAbsCoor());

  //if (directin.len() < 100)
//  this->shiftCoor(direction *dt * 5 * exp(-direction.len() / 30.0));
//  this->shiftDir(Quaternion(dt, this->randomRotAxis));

}



