
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli

   2005-06-10: (bensch) added new sturcture to support multiple inheritance
*/

/*!
 * @file class_id.h
 * @brief contains a list of orxonox ClassID's (identities to register classes and their SuperClasses)
 *
 *  this File is used to identify an Object with its Class and also with its sub/super-classes.
 *  this is also used by the ObjectManager/Factory to identify and load important classes
 *
 *  !! important !!
 *  When adding a new CLASS be sure about the following:
 *    1. if it is a (SUB)SUPERCLASS make sure there is still space left (if not think of a new approach)
 *    2. check if the Number you add is not refered twice, and that with (SUB)SUPERCLASSES there are no intersections
 *    3. be sure to add you stuff in the right section, and don't interest yourself for the order of things. :)
 */

#ifndef _CLASS_ID_H
#define _CLASS_ID_H

//! list of all classes to be loadable in via the ObjectManager
/**
 *
 * -------------------------------------------------------------------------------------------
 * Consider the Identifiers 0xABCDEFGH
 * The first two: A and B are superclass Identifiers !! THEY ARE ALREADY FULL !!
 *
 * The second three are for sub-superclass-groups inheritance:
 *  C: a Group identifier: can be anything from 1,2,3,4,5,6,7,8,9,a,b,c,d,e,f,g,h
 *  D,E: Member within the Group, to specify further deriavtions within the Group.
 *       These may be anything from 1,2,4,8 (at D and E)
 *  !! consider, that you __may not__ have a derivated class from group a and group b.
 *
 * The last three entries F,G,H are for any leaf classes in existence.
 * they are ordered in the following way:
 *  F: LEAF-GroupSpecifier
 *  G,H: UNIQUE NUMBER eithin F-Group.
 *
 * You only have to extend the Class with your ClassID-tag.
 * If something goes Wrong, you get an Assertion-Warning in BaseObject.
 * !! Abstrace/Non-total-leaf classes do not have a LEAF-part.
 * -------------------------------------------------------------------------------------------
 *
 * COUNT:
 * -> # max SuperClass-count        = 7 (not intersecting)
 *    # max SubSuperClass-count     = 15*7 = 105 (the 7 classes will be able to get derived from each other, but not over the SubSuperClass.)
 *    # max lowerClasses-count      = 3^16 = enough (they are Leaves, and may NOT be derived by any other class.)
 */
typedef enum ClassID
{
  // the Nothing CLASS (NULL)
  CL_NULL                       =    0x00000000,

  /// SUPER-classes
  CL_MASK_SUPER_CLASS           =    0xff000000,
  CL_BASE_OBJECT                =    0x00000000,

  CL_PARENT_NODE                =    0x01000000,

  CL_STORY_ENTITY               =    0x02000000,

  CL_PHYSICS_INTERFACE          =    0x04000000,

  CL_EVENT_LISTENER             =    0x08000000,

  CL_ELEMENT_2D                 =    0x10000000,

  CL_SYNCHRONIZEABLE            =    0x20000000,

  CL_WORLD_ENTITY               =    0x40000000,

  /// subsuper-classes
  // subsuper-classes derivations taken : 1, 2, 5, a, b, c.   << THIS IS A LIST OF ALL THE DCL_MASK_SUBSUPERCLASS_ID's taken
  CL_MASK_SUBSUPER_CLASS        =    0x00fff000,
  CL_MASK_SUBSUPER_CLASS_IDA    =    0x00f00000,
  CL_MASK_SUBSUPER_CLASS_IDB    =    0x000ff000,

  // lowest level classes
  // These are also referenced to as Leaf-classes
  CL_MASK_LOWLEVEL_CLASS        =    0x00000fff,

  CL_PREFERENCES                =    0X00000f51,

  /// SINGLETON classes (range from 0x00000000 to 0x000000ff)
  CL_MASK_SINGLETON             =    0x00000000,
  CL_ORXONOX                    =    0x00000001,
  CL_NULL_PARENT                =    0x00000002,
  CL_PILOT_PARENT               =    0x00000003,
  CL_OBJECT_MANAGER             =    0x00000004,
  CL_RESOURCE_MANAGER           =    0x00000005,
  CL_GARBAGE_COLLECTOR          =    0x00000006,
  CL_GAME_LOADER                =    0x00000007,
  CL_GRAPHICS_ENGINE            =    0x00000008,
  CL_TEXT_ENGINE                =    0x00000009,
  CL_LIGHT_MANAGER              =    0x0000000a,
  CL_EVENT_HANDLER              =    0x0000000b,
  CL_PHYSICS_ENGINE             =    0x0000000c,
  CL_CD_ENGINE                  =    0x0000000d,
  CL_PARTICLE_ENGINE            =    0x0000000e,
  CL_SOUND_ENGINE               =    0x0000000f,
  CL_ANIMATION_PLAYER           =    0x00000010,
  CL_TRACK_MANAGER              =    0x00000011,
  CL_TRACK_NODE                 =    0x00000012,
  CL_STATE                      =    0x00000013,
  CL_FRAMEWORK                  =    0x00000014,
  CL_CR_ENGINE                  =    0x00000015,
  CL_RENDER_2D                  =    0x00000021,
  CL_NULL_ELEMENT_2D            =    0x00000022,
  CL_SHELL_BUFFER               =    0x00000032,
  CL_GLGUI_HANDLER              =    0x00000040,
  CL_GLGUI_MAIN_WIDGET          =    0x00000041,
  CL_NETWORK_MANAGER            =    0x00000050,
  CL_SHARED_NETWORK_DATA        =    0x00000051,
  CL_ATMOSPHERIC_ENGINE         =    0x00000061,

  /// StoryEntities (range from 0x00000100 to 0x000001ff)
  CL_GAME_WORLD                 =    0x00101000,
  CL_GAME_WORLD_DATA            =    0x00102000,
  CL_GAME_RULES                 =    0x00104000,
  CL_NETWORK_GAME_RULES         =    0x00108000,
  CL_MISSION_GOAL               =    0x00110000,

  CL_CAMPAIGN                   =    0x00000101,
  CL_CAMPAIGN_DATA              =    0x00000102,
  CL_SIMPLE_GAME_MENU           =    0x00000103,
  CL_SIMPLE_GAME_MENU_DATA      =    0x00000104,
  CL_SINGLE_PLAYER_WORLD        =    0x00000105,
  CL_SINGLE_PLAYER_WORLD_DATA   =    0x00000106,
  CL_MULTI_PLAYER_WORLD         =    0x00000107,
  CL_MULTI_PLAYER_WORLD_DATA    =    0x00000108,
  CL_MOVIE_LOADER               =    0x00000109,

  CL_GAME_MENU                  =    0x00000110,
  CL_GAME_MENU_DATA             =    0x00000111,


  CL_MULTIPLAYER_TEAM_DEATHMATCH=    0x00000121,
  CL_SINGLEPLAYER_SHOOTEMUP     =    0x00000122,

  CL_KILL_TARGET                =    0x00105001,


  /// SUPER-PNodes
  CL_FIELD                      =    0x00201000,

  /// PNodes
  CL_CAMERA                     =    0x00000201,
  CL_CAMERA_TARGET              =    0x00000202,


  /// SUPER-WorldEntities
  CL_PLAYER                     =    0x00302000,

  CL_PLAYABLE                   =    0x00301000,
  CL_NPC                        =    0x00304000,
  CL_PROJECTILE                 =    0x00308000,
  CL_WEAPON                     =    0x00310000,
  CL_POWER_UP                   =    0x00320000,
  CL_EXTENDABLE                 =    0x00340000,

  /// WorldEntities (range from 0x00000300 to 0x000005ff)
  // Environments
  CL_ENVIRONMENT                =    0x00000303,
  CL_SATELLITE                  =    0x00000304,
  CL_SKYBOX                     =    0x00000305,
  CL_SKYSPHERE                  =    0x00000306,
  CL_TERRAIN                    =    0x00000307,
  CL_WATER                      =    0x00000308,
  CL_PLANET                     =    0x00000309,
  CL_BUILDING                   =    0x00000310,
  CL_MAPPED_WATER               =    0x00000311,
  CL_BSP_ENTITY                 =    0x00000312,
  CL_SKYDOME                    =    0x00000313,
  CL_DOOR                       =    0x00000314,
  CL_REPAIR_STATION             =    0x00000315,
  CL_CRANE                      =    0x00000316,
  CL_BRAKING_WALL               =    0X00000317,

  // Playables
  CL_SPACE_SHIP                 =    0x0000035a,
  CL_HELICOPTER                 =    0x0000035b,
  CL_SPAWNING_POINT             =    0x0000035c,
  CL_MD2_CREATURE               =    0x0000035d,
  CL_HOVER                      =    0x0000035e,
  CL_TURBINE_HOVER              =    0x0000035f,
  CL_SPACECRAFT_2D              =    0x00000360,
  CL_CRUIZER                    =    0x00000361,
  CL_SPECTATOR                  =    0x0000036a,
  CL_COLLISION_PROBE            =    0x0000036b,
  CL_FPS_PLAYER                 =    0x0000036c,

  // Powerups
  CL_TURRET_POWER_UP            =    0x00000381,
  CL_LASER_POWER_UP             =    0x00000382,
  CL_WEAPON_POWER_UP            =    0x00000383,
  CL_PARAM_POWER_UP             =    0x00000384,

  // Weapons
  CL_TEST_GUN                   =    0x000003a0,
  CL_LASER_CANNON               =    0x000003a1,
  CL_TURRET                     =    0x000003a2,
  CL_AIMING_TURRET              =    0x000003a3,
  CL_CANNON                     =    0x000003a4,
  CL_TARGETING_TURRET           =    0x000003a5,
  CL_HYPERBLASTER               =    0x000003a6,
  CL_FPS_SNIPER_RIFLE           =    0x000003a7,
  CL_FPS_LASER_RIFLE            =    0x000003a8,

  // Projectiles
  CL_TEST_BULLET                =    0x000003e0,
  CL_ROCKET                     =    0x000003e1,
  CL_LASER                      =    0x000003e2,
  CL_RAIL_PROJECTILE            =    0x000003e3,
  CL_BOMB                       =    0x000003e4,
  CL_GROUND_TURRET              =    0x000003e5,
  CL_GUIDED_MISSILE             =    0x000003e6,
  CL_HYPERBLAST                 =    0x000003e7,

  // NPC's
  CL_NPC_TEST1                  =    0x00000401,
  CL_NPC_TEST2                  =    0x00000402,
  CL_GENERIC_NPC                =    0x00000403,
  CL_ATTRACTOR_MINE             =    0x00000404,

  // Testing Entities
  CL_TEST_ENTITY                =    0x00000409,

  // misc
  CL_MOVIE_ENTITY               =    0x00000511,
  CL_RECORDER                   =    0x00000512,

  CL_IMAGE_ENTITY               =    0x00000513,
  CL_IMAGE_PLANE                =    0x00000514,
  CL_MODEL_ENTITY               =    0x00000515,
  CL_TEXT_ELEMENT               =    0x00000516, /// TODO MOVE


  /// GamePlay (range from 0x00000600 0x000006ff)
  CL_EVENT                      =    0x00000601,
  CL_KEY_MAPPER                 =    0x00000602,
  CL_CROSSHAIR                  =    0x00000612,

  CL_WEAPON_MANAGER             =    0x00000603,
  CL_AMMO_CONTAINER             =    0x00000604,
  CL_HUD                        =    0x00000620,


  CL_SCRIPT_MANAGER             =    0x00000650,
  CL_SCRIPT                     =    0x00000651,
  CL_SCRIPT_CLASS               =    0x00000652,
  CL_SCRIPT_TRIGGER             =    0x00000653,


  /// Physics stuff (range from 0x00000700 to 0x000008ff)
  CL_PHYSICS_CONNECTION         =    0x00000701,
  CL_FIELD_GRAVITY              =    0x00000710,
  CL_FIELD_POINT_GRAVITY        =    0x00000711,
  CL_FIELD_TWIRL                =    0x00000712,


  /// Collision
  CL_COLLISION                  =    0x00780000,
  CL_COLLISION_HANDLE           =    0x00000712,
  CL_COLLISION_REACTION         =    0X00000713,
  CL_CR_PHYSICS_MOMENTUM        =    0X00000714,
  CL_CR_PHYSICS_GROUND_WALK     =    0X00000715,
  CL_CR_PHYSICS_FULL_WALK       =    0X00000716,
  CL_CR_OBJECT_DAMAGE           =    0X00000717,
  CL_CR_OBJECT_PICKUP           =    0X00000718,
  CL_CR_VERTEX_TRAFO            =    0X00000719,
  CL_CR_SPECIAL_CALLBACK        =    0X00000720,


  CL_BV_TREE                    =    0x00701000,
  CL_BV_TREE_NODE               =    0x00702000,
  CL_OBB_TREE                   =    0x00000721,
  CL_OBB_TREE_NODE              =    0x00000722,
  CL_BOUNDING_VOLUME            =    0x00710000,
  CL_OBB                        =    0x00720000,
  CL_BOUNDING_SPHERE            =    0x00740000,
  CL_AABB_TREE_NODE             =    0x00000724,                //FIXME: is this correct? AABB_TREE_NODE isA BV_TREE_NODE
  CL_AABB                       =    0x00780000,                //FIXME: is this correct? AABB isA BOUNDING_VOLUME



  /// Graphical stuff (range from 0x00000800 to 0x00000aff)
  /// SUPER-Textures
  CL_MATERIAL                   =    0x00801000,
  CL_TEXTURE                    =    0x00802000,
  CL_TEXTURE_SEQUENCE           =    0x00804000,
  CL_TEXT                       =    0x00808000,
  CL_MULTI_LINE_TEXT            =    0x00000840,
  CL_LIMITED_WIDTH_TEXT         =    0x00000841,

  // Texutres.
  CL_FONT                       =    0x00000802,
  CL_MOVIE_PLAYER               =    0x00000805,
  CL_MEDIA_CONTAINER            =    0x00000806,

  /// Super-Models
  CL_MODEL                      =    0x00901000,
  CL_STATIC_MODEL               =    0x00902000,
  CL_VERTEX_ARRAY_MODEL         =    0x00904000,
  CL_INTERACTIVE_MODEL          =    0x00908000,        ///FIXME: is this ok bensch?

  // Models
  CL_OBJ_MODEL                  =    0x00000907,

  CL_PRIMITIVE_MODEL            =    0x00000908,
  CL_MD2_MODEL                  =    0x00000909,
  CL_HEIGHT_MAP                 =    0x0000090a,
  CL_GRID                       =    0x0000090b,
  CL_BSP_MODEL                  =    0x0000090c, //!FIXME

  CL_SHADER                     =    0x00000811,
  CL_LIGHT                      =    0x00000821,

  CL_BILLBOARD                  =    0x00000a01,

  CL_GRAPHICS_EFFECT            =    0x00a01000,
  CL_WEATHER_EFFECT             =    0x00a10000,
  CL_FOG_EFFECT                 =    0x00000a10,
  CL_VOLFOG_EFFECT              =    0x00000a11,
  CL_LENSE_FLARE                =    0x00000a12,
  CL_RAIN_EFFECT                =    0x00000a13,
  CL_SNOW_EFFECT                =    0x00000a14,
  CL_CLOUD_EFFECT               =    0x00000a15,
  CL_LIGHTNING_EFFECT          =    0x00000a16,
  CL_EXPLOSION                  =    0x00000a20,
  CL_LIGHTNING_BOLT             =    0x00000a21,



  // Particles
  CL_PARTICLE_SYSTEM            =    0x00a02000,
  CL_DOT_PARTICLES              =    0x00000aa1,
  CL_SPARK_PARTICLES            =    0x00000aa2,
  CL_SPRITE_PARTICLES           =    0x00000aa3,
  CL_MODEL_PARTICLES            =    0x00000aa4,
  //  CL_PNODE_PARTICLES            =    0x00a20000,

  CL_PARTICLE_EMITTER           =    0x00a04000,
  CL_DOT_EMITTER                =    0x00000ab1,
  CL_PLANE_EMITTER              =    0x00000ab2,
  CL_BOX_EMITTER                =    0x00000ab3,
  CL_SPHERE_EMITTER             =    0x00000ab4,
  //  CL_MODEL_EMITTER              =    0x00000a25,

  // Element2D's  (range from 0x00000b00 to 0x00000bff)
  /// GL-GUI
  CL_GLGUI_WIDGET               =    0x00b01000,
  CL_GLGUI_BUTTON               =    0x00b02000,
  CL_GLGUI_PUSHBUTTON           =    0x00000b03,
  CL_GLGUI_CHECKBUTTON          =    0x00000b04,
  CL_GLGUI_RADIOBUTTON          =    0x00000b05,
  CL_GLGUI_SLIDER               =    0x00000b06,
  CL_GLGUI_PROGRESSBAR          =    0x00000b07,
  CL_GLGUI_CONTAINER            =    0x00b04000,
  CL_GLGUI_BOX                  =    0x00000b17,
  CL_GLGUI_FRAME                =    0x00000b18,
  CL_GLGUI_WINDOW               =    0x00000b19,
  CL_GLMENU_IMAGE_SCREEN        =    0x00000b20,
  CL_GLGUI_BAR                  =    0x00000b30,
  CL_GLGUI_CURSOR               =    0x00000b50,
  CL_GLGUI_TEXT                 =    0x00000b51,
  CL_GLGUI_INPUTLINE            =    0x00000b60,
  CL_GLGUI_TEXTFIELD            =    0x00000b61,
  CL_GLGUI_IMAGE                =    0x00000b70,
  CL_GLGUI_TABLE                =    0x00000b71,

  CL_GLGUI_NOTIFIER             =    0x00000b80,

  // QT_GUI
  CL_GUI_SAVEABLE               =    0x00b10000,
  CL_QTGUI_BUTTON               =    0x00000ba0,
  CL_QTGUI_PUSHBUTTON           =    0x00000ba3,
  CL_QTGUI_CHECKBUTTON          =    0x00000ba4,
  CL_QTGUI_RADIOBUTTON          =    0x00000ba5,
  CL_QTGUI_CONTAINER            =    0x00b200a0,
  CL_QTGUI_BOX                  =    0x00000ba7,
  CL_QTGUI_FRAME                =    0x00000ba8,
  CL_QTGUI_WINDOW               =    0x00000ba9,
  CL_QTMENU_IMAGE_SCREEN        =    0x00000ba0,
  CL_QTGUI_BAR                  =    0x00000ba0,

  /// AUDIO stuff (range from 0x00000c00 to 0x00000cff)
  CL_SOUND_BUFFER               =    0x00000c01,
  CL_SOUND_SOURCE               =    0x00000c02,
  CL_SOUND_OGG_PLAYER           =    0x00000c11,


  /// NETWORK stuff (range from 0x00000d00 to 0x00000dff)
  CL_DATA_STREAM                =    0x00d01000,
  CL_NETWORK_STREAM             =    0x00000d01,
  CL_NETWORK_PROTOCOL           =    0x00000d02,
  CL_NETWORK_SOCKET             =    0x00000d03,
  CL_SERVER_SOCKET              =    0X00000d04,
  CL_CONNECTION_MONITOR         =    0x00000d05,
  CL_HANDSHAKE                  =    0x00000d06,
  CL_NETWORK_GAME_MANAGER       =    0x00000d07,
  CL_MESSAGE_MANAGER            =    0x00000d08,
  CL_PLAYER_STATS               =    0x00000d09,
  CL_SIMPLE_SYNC                =    0x00000d0a,



  /// MISCELANEOUS: (range from 0x00000e00 to 0x00000fff)
  CL_ANIMATION                  =    0x00000e01,
  //  CL_ANIMATION3D                =    0x00000b02,
  CL_QUICK_ANIMATION            =    0x00000e02,

  CL_FACTORY                    =    0x00e01000,
  CL_FAST_FACTORY               =    0x00000ea2,
  CL_LOAD_PARAM                 =    0x00000ea3,
  CL_DYNAMIC_LOADER             =    0x00000ea8,

  CL_INI_PARSER                 =    0x00000e04,

  CL_SHELL                      =    0x00000e10,
  CL_SHELL_COMMAND              =    0x00000e11,
  CL_SHELL_COMMAND_CLASS        =    0x00000e12,
  CL_SHELL_INPUT                =    0x00000e13,
  CL_SHELL_COMPLETION           =    0x00000e14,
  CL_SHELL_COMMAND_ALIAS        =    0x00000e15,

  CL_TRACK_ELEMENT              =    0x00000e2b,
  CL_LIST                       =    0x00000e25,
  CL_SUBSTRING                  =    0x00000e26,
  CL_CURVE                      =    0x00000e28,
  CL_CHARACTER_ATTRIBUTES       =    0x00000e2a,
  CL_NUMBER                     =    0x00000e2c,
  CL_EXECUTOR                   =    0x00000e2d,

  // Spatial Data Separation
  CL_SPATIAL_SEPARATION         =    0x00000e0d,
  CL_QUADTREE                   =    0x00000e0e,
  CL_QUADTREE_NODE              =    0x00000e0f,
};


#endif /* _CLASS_ID_H */
