/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "aiming_system.h"

#include "util/loading/load_param.h"

#include "state.h"

#include <vector>


using namespace std;


/**
 * standart constructor
 */
AimingSystem::AimingSystem (const TiXmlElement* root)
{
  this->init();


  if (root)
    this->loadParams(root);
}


/**
 * destroys a AimingSystem
*/
AimingSystem::~AimingSystem ()
{}


/**
 * initializes the AimingSystem
 */
void AimingSystem::init()
{
  this->setClassID(CL_CROSSHAIR, "AimingSystem");
  this->setName("AimingSystem");
}


void AimingSystem::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);

//   LoadParam(root, "texture", this, AimingSystem, setTexture)
//       .describe("the texture-file to load onto the AimingSystem");
//
//   LoadParam(root, "size", this, AimingSystem, setSize)
//       .describe("the size of the AimingSystem in Pixels");
//
//   LoadParam(root, "rotation-speed", this, AimingSystem, setRotationSpeed)
//       .describe("the Speed with which the AimingSystem should rotate");
}



/**
 * get back the nearest target
 * @returns the nerest target
 */
inline WorldEntity* AimingSystem::getNearestTarget()
{
  if( this->selectionList.size() == 0)
    return NULL;
  else if( this->selectionList.size() == 1)
    return this->selectionList.back();

  WorldEntity* nearestEntity     = this->selectionList.back();
  float        distance          = 0.0f;
  float        smalestDistance   = this->range * 5.0f;


  for( int i = 0; i < this->selectionList.size(); i++)
  {
    distance = fabs((this->getAbsCoor() - this->selectionList[i]->getAbsCoor()).len());
    if( distance < smalestDistance)
    {
      nearestEntity = this->selectionList[i];
      smalestDistance = distance;
    }
  }

  return nearestEntity;
}


/**
 * called when an object is "selected"
 *  @param damage damage to be dealt
 *  @param killer the entity
 */
void AimingSystem::hit(float damage, WorldEntity* killer)
{
  this->selectionList.push_back(killer);
}



/**
 * ticks the AimingSystem
 * @param dt the time to ticks
 */
void AimingSystem::tick(float dt)
{

  this->selectionList.clear();
}


/**
 * draws the crosshair
 */
void AimingSystem::draw() const
{
}
