/*!
 * @file network_game_rules.h
 * @brief Definition of NetworkGameRules
 */

#ifndef _NETWORK_GAME_RULES_H
#define _NETWORK_GAME_RULES_H

#include "game_rules.h"

#include "player_stats.h"

class TiXmlElement;

class NetworkGameRules : public GameRules
{

  public:
    NetworkGameRules( const TiXmlElement* root );
    virtual ~NetworkGameRules();
    
    virtual int getTeamForNewUser();
    virtual ClassID getPlayableClassId( int userId, int team );
    virtual std::string getPlayableModelFileName( int userId, int team, ClassID classId );
    virtual std::string getPlayableModelTextureFileName( int userId, int team, ClassID classId );
    
    virtual PlayerStats * getNewPlayerStats( int userId ){ return new PlayerStats( userId ); }
    
    virtual void handleChatMessage( int userId, const std::string & message, int messageType ) = 0;
    
    void shellSay( const std::string & message );


  private:

};

#endif /* _NETWORK_GAME_RULES_H */
