/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "network_game_rules.h"

#include "network_game_manager.h"

using namespace std;


/**
 * standard constructor
 */
NetworkGameRules::NetworkGameRules ( const TiXmlElement* root )
  : GameRules( root )
{
  this->setClassID( CL_NETWORK_GAME_RULES, "NetworkGameRules");
}


/**
 * standard deconstructor
 */
NetworkGameRules::~NetworkGameRules ()
{
}


std::string NetworkGameRules::getPlayableModelTextureFileName( int userId, int team, ClassID classId )
{
  return "";
}

std::string NetworkGameRules::getPlayableModelFileName( int uesrId, int team, ClassID classId )
{
  return "models/ships/reap_#.obj";
}

ClassID NetworkGameRules::getPlayableClassId( int userId, int team )
{
  return CL_SPACE_SHIP;
}

int NetworkGameRules::getTeamForNewUser( )
{
  return 0;
}


void NetworkGameRules::shellSay( const std::string & message )
{
  NetworkGameManager::getInstance()->sendChatMessage( message, 0 );
}


