/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "multi_player_world.h"
#include "multi_player_world_data.h"

#include "util/loading/factory.h"
#include "util/loading/load_param.h"
#include "shell_command.h"

#include "cd_engine.h"

#include "network_manager.h"
#include "network_game_manager.h"

#include "state.h"


using namespace std;


//! Register a command to print some multiplayer world infos
SHELL_COMMAND(debug, MultiPlayerWorld, debug);


//! This creates a Factory to fabricate a MultiPlayerWorld
CREATE_FACTORY(MultiPlayerWorld, CL_MULTI_PLAYER_WORLD);


MultiPlayerWorld::MultiPlayerWorld(const TiXmlElement* root)
  : GameWorld()
{
  this->setClassID(CL_MULTI_PLAYER_WORLD, "MultiPlayerWorld");

  this->dataTank = new MultiPlayerWorldData();

  this->loadParams(root);
}


/**
 *  remove the MultiPlayerWorld from memory
 *
 *  delete everything explicitly, that isn't contained in the parenting tree!
 *  things contained in the tree are deleted automaticaly
 */
MultiPlayerWorld::~MultiPlayerWorld ()
{
  PRINTF(3)("MultiPlayerWorld::~MultiPlayerWorld() - deleting current world\n");
  if( this->dataTank)
    delete this->dataTank;
}


/**
 * loads the parameters of a MultiPlayerWorld from an XML-element
 * @param root the XML-element to load from
 */
void MultiPlayerWorld::loadParams(const TiXmlElement* root)
{
  GameWorld::loadParams(root);

  PRINTF(4)("Creating a MultiPlayerWorld\n");
}


/**
 *  synchronizes the network since this is a network world
 *
 * this function overrides the synchrinize from the GameWorld
 */
void MultiPlayerWorld::synchronize()
{
  NetworkManager::getInstance()->synchronize(this->dtS);
}


/**
 * kicks the CDEngine to detect the collisions between the object groups in the world
 */
void MultiPlayerWorld::collisionDetection()
{
  //CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS), this->dataTank->objectManager->getObjectList(OM_PLAYERS));

  PRINTF(5)("\n-----------------------------------------\nchecking OM_PLAYERS vs OM_PLAYERS_PROJ\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS_PROJ),
  this->dataTank->objectManager->getObjectList(OM_PLAYERS));
  PRINTF(5)("\n-----------------------------------------\nchecking OM_PLAYERS vs OM_GROUP_01_PROJ\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS),
    this->dataTank->objectManager->getObjectList(OM_GROUP_00_PROJ));
  PRINTF(5)("\n-----------------------------------------\nchecking OM_PLAYERS vs OM_GROUP_01_PROJ\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS),
    this->dataTank->objectManager->getObjectList(OM_GROUP_01_PROJ));
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS),
    this->dataTank->objectManager->getObjectList(OM_GROUP_00));
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_PLAYERS),
    this->dataTank->objectManager->getObjectList(OM_GROUP_01));



  PRINTF(5)("\n-----------------------------------------\nchecking OM_GROUP_00 vs OM_GROUP_01_PROJ\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_00),
    this->dataTank->objectManager->getObjectList(OM_GROUP_01_PROJ));
  PRINTF(5)("\n-----------------------------------------\nchecking OM_GROUP_00 vs OM_GROUP_01\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_00),
    this->dataTank->objectManager->getObjectList(OM_GROUP_01));
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_00),
    this->dataTank->objectManager->getObjectList(OM_PLAYERS_PROJ));

  PRINTF(5)("\n-----------------------------------------\nchecking OM_GROUP_01 vs OM_GROUP_00_PROJ\n\n");
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_01),
    this->dataTank->objectManager->getObjectList(OM_GROUP_00_PROJ));
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_01),
    this->dataTank->objectManager->getObjectList(OM_GROUP_00));
  CDEngine::getInstance()->checkCollisions(this->dataTank->objectManager->getObjectList(OM_GROUP_01),
    this->dataTank->objectManager->getObjectList(OM_PLAYERS_PROJ));



    // ground collision detection: BSP Model
  CDEngine::getInstance()->checkCollisionGround(this->dataTank->objectManager->getObjectList(OM_GROUP_00));
  CDEngine::getInstance()->checkCollisionGround(this->dataTank->objectManager->getObjectList(OM_GROUP_01));
  CDEngine::getInstance()->checkCollisionGround(this->dataTank->objectManager->getObjectList(OM_PLAYERS));
}


/**
 * some debug ouptut - shell command
 */
void MultiPlayerWorld::debug()
{
  ((MultiPlayerWorldData*)this->dataTank)->debug();
}

/**
 * cleanup
 * @return
 */
ErrorMessage MultiPlayerWorld::unloadData( )
{

  GameWorld::unloadData();

  delete NetworkManager::getInstance();
  delete NetworkGameManager::getInstance();

  State::setOnline( false );

  return ErrorMessage();
}
