/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_SHELL

#include "shell_buffer.h"

#include <stdarg.h>

#include "debug.h"
#include "shell.h"
#include "lib/util/threading.h"

namespace OrxShell
{
  /**
   * @brief standard constructor
   */
  ShellBuffer::ShellBuffer ()
  {
    ShellBuffer::singletonRef = this;

    this->lineCount = 0;
    this->bufferArray[0] = '\0';

    this->setMaxBufferSize(100);
  }

  ShellBuffer* ShellBuffer::singletonRef = NULL;
  std::list<std::string> ShellBuffer::buffer;
  char ShellBuffer::bufferArray[SHELL_BUFFER_SIZE] = "";


  /**
   * @brief standard deconstructor
   */
  ShellBuffer::~ShellBuffer ()
  {
    ShellBuffer::singletonRef = NULL;
  }

  /**
   * @brief deletes all the Buffers
   */
  void ShellBuffer::flush()
  {
    this->buffer.clear();
  }

  /**
   * @brief adds a new Line to the List of Buffers
   * @param line the Line as in the first argument in printf
   */
  void ShellBuffer::addBufferLineStatic(const char* line, ...)
  {
    static OrxThread::Mutex ShellBuffer__bufferMutex;

    OrxThread::MutexLock bufferLock(&ShellBuffer__bufferMutex);

    va_list arguments;
    va_start(arguments, line);
    vsnprintf(ShellBuffer::bufferArray, SHELL_BUFFER_SIZE, line, arguments);
    va_end(arguments);

#if DEBUG_LEVEL < 3
    if (ShellBuffer::singletonRef == NULL)
#endif
      printf(ShellBuffer::bufferArray);
#if DEBUG_LEVEL < 3
    else
#else
    if (ShellBuffer::singletonRef != NULL)
#endif
      ShellBuffer::singletonRef->addBufferLine(ShellBuffer::bufferArray);
  }

  /**
   * @brief add a Line to the List of Buffers
   * @param line
   * @param arguments
   *
   * This function Adds one line to the buffer.
   * and displays the line as the First Line of the display-buffer
   */
  void ShellBuffer::addBufferLine(const char* line)
  {
    std::string inputBuffer = this->keepBuffer + line;

    unsigned int lineBegin = 0;
    unsigned int lineEnd = 0;
    // adding all the new Lines
    while (lineEnd < inputBuffer.size())
    {
      lineBegin = lineEnd;
      lineEnd = inputBuffer.find('\n', (lineBegin == 0) ? 0: ++lineBegin);
      if (likely(lineEnd != std::string::npos ))
      {
        this->lineCount++;
        this->buffer.push_front(inputBuffer.substr(lineBegin, lineEnd - lineBegin));
      }
      else      // No end of Line reached.
      {
        this->keepBuffer = inputBuffer.substr(lineBegin, inputBuffer.size() - lineBegin);
        break;
      }

      if (inputBuffer[lineBegin] == '\n')
        lineBegin++, lineEnd++;

      if (this->buffer.size() > this->maxBufferSize)
        this->buffer.pop_back();
    }
  }

  /**
   * @brief displays some nice output from the Shell
   */
  void ShellBuffer::debug() const
  {
    PRINT(3)("Debugging output to console (not this shell)\n");

    std::list<std::string>::const_iterator bufferLine;
    for (bufferLine = --this->buffer.end(); bufferLine != this->buffer.begin(); --bufferLine)
      printf((*bufferLine).c_str());
  }

}
