/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Patrick Boenzli : Vector::scale()
                                    Vector::abs()

   Quaternion code borrowed from an Gamasutra article by Nick Bobick and Ken Shoemake

   2005-06-02: Benjamin Grauer: speed up, and new Functionality to Vector (mostly inline now)
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_MATH

#include "vector.h"
#ifdef DEBUG
  #include "debug.h"
#else
  #include <stdio.h>
  #define PRINT(x) printf
#endif


/////////////
/* VECTORS */
/////////////
/**
 *  returns the this-vector normalized to length 1.0
 * @todo there is some error in this function, that i could not resolve. it just does not, what it is supposed to do.
 */
Vector Vector::getNormalized() const
{
  float length = this->len();
  if (unlikely(length == 0.0))
    return *this;
  else
    return (*this / length);
}

/**
 *  Vector is looking in the positive direction on all axes after this
*/
Vector Vector::abs()
{
  Vector v(fabs(x), fabs(y), fabs(z));
  return v;
}



/**
 *  Outputs the values of the Vector
 */
void Vector::debug() const
{
  PRINT(0)("x: %f; y: %f; z: %f", x, y, z);
  PRINT(0)(" lenght: %f", len());
  PRINT(0)("\n");
}
