/*!
 * @file matrix.h
 * @brief Definition of a 3x3 matrix.
 */

#include "vector.h"

//! Matrix is a 3x3 Matrix class with most important functions
class Matrix
{
  public:
    Matrix() : m11(0), m12(0), m13(0), m21(0), m22(0), m23(0), m31(0), m32(0), m33(0) { };

    Matrix ( float m11, float m12, float m13,
             float m21, float m22, float m23,
             float m31, float m32, float m33 );
    Matrix(const float m[3][3]);

    Matrix operator+ (const Matrix& m) const;
    Matrix operator- (const Matrix& m) const;
    Matrix operator* (float k) const;
    Vector operator* (const Vector& v) const;

    Matrix getTransposed() const;
    void toVectors(Vector& m1, Vector& m2, Vector& m3) const;

    float getDeterminant() const;

    int getEigenValues(Vector& eigenVectors) const;
    void getEigenVectors(Vector& a, Vector& b, Vector& c) const;

    /** @returns the Identity-Matrix (diagonal 3x3 with 1's everywhere) */
    static Matrix identity() { return Matrix(1,0,0, 0,1,0, 0,0,1); }

    void debug() const;

  public:
    float m11;              //!< Matrix Entry [0][0]
          float m12;        //!< Matrix Entry [0][1]
                float m13;  //!< Matrix Entry [0][2]
    float m21;              //!< Matrix Entry [1][0]
          float m22;        //!< Matrix Entry [1][1]
                float m23;  //!< Matrix Entry [1][2]
    float m31;              //!< Matrix Entry [2][0]
          float m32;        //!< Matrix Entry [2][1]
                float m33;  //!< Matrix Entry [2][2]
};
