/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

/*!
 * @file line.h
 * A basic 3D math line framework
 *
 * Contains class to handle lines
*/

#ifndef __LINE_H_
#define __LINE_H_

#include "compiler.h"
#include "vector.h"
#include "rotation_OBSOLETE.h"

//! 3D line
/**
  Class to store Lines in 3-dimensional space

  Supports line-to-line distance measurements and rotation
*/
class Line
{
  public:

  Vector r;   //!< Offset
  Vector a;   //!< Direction

  Line ( Vector r, Vector a) : r(r), a(a) {}  //!< assignment constructor
  Line () : r(Vector(0,0,0)), a(Vector (1,1,1)) {}
  ~Line () {}

  float distance (const Line& l) const;
  float distancePoint (const Vector& v) const;
  float distancePoint (const sVec3D& v) const;
  Vector* footpoints (const Line& l) const;
  float len () const;

  void rotate(const Rotation& rot);
};


#endif /* __LINE_H_ */

