/*!
 * @file fps_player.h
 * Implements a playable for fps games
 */

#ifndef _FPS_PLAYER_H
#define _FPS_PLAYER_H


#include "playable.h"


class FPSPlayer : public Playable
{

  public:
    FPSPlayer(const TiXmlElement* root = NULL);
    virtual ~FPSPlayer();

    virtual void loadParams(const TiXmlElement* root);

    virtual void setPlayDirection(const Quaternion& rot, float speed = 0.0f);

    virtual void enter();
    virtual void leave();

    virtual void reset();


    virtual void tick(float time);
    virtual void draw() const;


    virtual void process(const Event &event);

  private:
    void init();

    bool                  bLeft;
    bool                  bRight;
    bool                  bForward;
    bool                  bBackward;
    bool                  bJump;              //!< jumping
    bool                  bPosBut;             //!< position button

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction


    float                 heading;
    float                 attitude;

    PNode                 cameraNode;

    float                 fallVelocity;        //!< velocity for falling down
    float                 jumpForce;           //!< the jump force
};

#endif
