#ifndef _DOOR_H
#define _DOOR_H

#include "world_entity.h"

#include "md2/md2Model.h"

class TiXmlElement;


//! animation names enumeration
typedef enum DoorAnimType
{
  DOOR_OPEN = 0,
  DOOR_CLOSE,

  DOOR_MAX_ANIMATIONS
};


class Door : public WorldEntity
{
  public:
    Door(const TiXmlElement* root = NULL);
    virtual ~Door ();

    virtual void loadParams(const TiXmlElement* root);

    void setActionRadius(float radius) { this->actionRadius = radius; }
    void setScale(float scale) { this->scale = scale; }

    void open();
    void close();

    void lock() { this->bLocked = true; }
    void unlock() { this->bLocked = false; }
    bool isLocked() const { return this->bLocked; }


    virtual void tick (float time);


  private:
    void init();
    bool checkOpen();
    void setAnimation(int animNum, int playbackMode = 0);


  private:
    bool           bOpen;             //!< true if the door is open
    bool           bLocked;           //!< true if this door is locked
    float          actionRadius;      //!< action radius
    float          scale;             //!< the scale of the model

    static sAnim   animationList[2];  //!< list of the animations


};

#endif /* _DOOR_H */
