
/*!
 * @file multiplayer_team_deathmatch.h
 * Defines game rules for team deathmatch games
 *
 * currently there are only two teams supported
 */

#ifndef _MULTIPLAYER_TEAM_DEATHMATCH_H
#define _MULTIPLAYER_TEAM_DEATHMATCH_H

#include "network_game_rules.h"

#include "glgui.h"
#include "specials/glgui_notifier.h"

class TiXmlElement;
class ObjectManager;
class Player;
class ImagePlane;

enum
{
  GAMESTATE_PRE_GAME = 0,
  GAMESTATE_GAME,
  GAMESTATE_POST_GAME
};


class MultiplayerTeamDeathmatch : public NetworkGameRules, public EventListener
{

  public:
    MultiplayerTeamDeathmatch(const TiXmlElement* root = NULL);
    virtual ~MultiplayerTeamDeathmatch();

    virtual void loadParams(const TiXmlElement* root);

    virtual int getTeamForNewUser();
    virtual ClassID getPlayableClassId( int userId, int team );
    virtual std::string getPlayableModelFileName( int userId, int team, ClassID classId );

    virtual void registerSpawn( WorldEntity * we );

    virtual void tick(float dt);
    void draw();

    inline void setDeathPenaltyTimeout(float time) { this->deathTimeout = time; }
    inline void setMaxKills(int kills) { this->maxKills = kills; }
    
    inline void setNumTeams( int numTeams ){ this->numTeams = numTeams; }
    inline int getNumTeams(){ return this->numTeams; }
    
    int getRandomTeam();
    
    virtual void process(const Event &event);
    
    void onKill( WorldEntity * victim, WorldEntity * killer );
    void onRespawn( int userId );
    
    virtual void handleChatMessage( int userId, const std::string & message, int messageType );
    
    void respawnPlayable( Playable * playable, int teamId, float delay );

  protected:
    virtual void checkGameRules();

  private:
    bool               bLocalPlayerDead;           //!< true if the local player is dead
    float              deathTimeout;               //!< timeout a player cannot play if he/she dies
    float              timeout;                    //!< time counted if player dead
    int                maxKills;                   //!< max kills for winning condition

    int                numTeams;                   //!< number of teams

    std::map<int,int>  teamScore;                  //!< team score

    int                currentGameState;           //!< game state
    float              gameStateTimer;             //!< if less than 0 -> change game state

    bool               bShowTeamChange;            //!< if true -> show team change dialog

    OrxGui::GLGuiBox* box;
    
    OrxGui::GLGuiInputLine* input;
    
    void calculateTeamScore();
    void nextGameState();
    void handleTeamChanges();
    void teamChange( int userId );
    void assignPlayable();
    
    void onButtonSpectator();
    void onButtonRandom();
    void onButtonTeam0();
    void onButtonTeam1();
    void onButtonCancel();
    void onButtonExit();
    
    void onInputEnter( const std::string & text );
    
    OrxGui::GLGuiBox* statsBox;
    OrxGui::GLGuiTable* table;
    void tickStatsTable();
    
    void showStats();
    void hideStats();
};


#endif /* _MULTIPLAYER_TEAM_DEATHMATCH_H */
