/*!
 * @file game_menu.h
 *  a StoryEntity that contains a simple game menu
 */

#ifndef _GAME_MENU_H
#define _GAME_MENU_H


#include "game_world.h"
#include "game_world_data.h"
#include <vector>
#include "glgui.h"

namespace OrxSound { class SoundSource; }

//! a simple game menu based on a story entity
/**
 * This is a simple menu, that is based on the StoryEntity. Therefore this menu is absolutly
 * loadable and is exchangeable very easely :D
 */
class GameMenu : virtual public GameWorld, virtual public EventListener
{

  public:
    GameMenu(const TiXmlElement* root = NULL);
    virtual ~GameMenu();

    virtual void loadParams(const TiXmlElement* root);

    virtual ErrorMessage init();
    virtual ErrorMessage loadData();
    virtual ErrorMessage unloadData();

    virtual bool start();
    virtual bool stop();

    virtual void process(const Event &event);


    void startLevel(int level);

    void showMainMenu();
    void showCampaigns();
    void showMultiPlayer();
    void showOptionsMenu();
    
    void showClientMenu();
    void connectToServer();
    
    void showServerMenu();
    void createServer();


    void quitMenu();

  protected:
    virtual void tick();
    virtual void collide();


  private:
    void showSecondLevelElement(OrxGui::GLGuiBox* element);


    void animateScene(float dt);
    void switchMenuLayer(int layer1, int layer2);
    void sliderTo(const Element2D* element, float bias = 0.0f);
    void setSelectorSound(const std::string& selectorSound);

    


  private:
    OrxGui::GLGuiBox*                 mainMenuBox;
    OrxGui::GLGuiBox*                 levelsBox;
    OrxGui::GLGuiBox*                 networkBox;
    
    OrxGui::GLGuiBox*                 clientNetworkBox;
    OrxGui::GLGuiInputLine*           ipInputLine;
    
    OrxGui::GLGuiBox*                 serverNetworkBox;

    OrxGui::GLGuiBox*                 optionsBox;
    OrxGui::GLGuiBox*                 generalBox;
    OrxGui::GLGuiBox*                 audioBox;
    OrxGui::GLGuiBox*                 videoBox;
    OrxGui::GLGuiBox*                 controlBox;

    OrxGui::GLGuiBox*                 currentlyOpened;

    Vector                            cameraVector;

    OrxSound::SoundSource*            selectorSource;
};



//! the simple game menu data
class GameMenuData : public GameWorldData
{

  public:
    GameMenuData();
    virtual ~GameMenuData();

    virtual ErrorMessage init();


  protected:
    virtual ErrorMessage loadGUI(const TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(const TiXmlElement* root);
    virtual ErrorMessage loadScene(const TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();

};


#endif /* _GAME_WORLD_H */
