/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_textfield.h"

#include "text.h"

namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiTextfield::GLGuiTextfield ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiTextfield::~GLGuiTextfield()
  {}

  /**
   * initializes the GUI-element
   */
  void GLGuiTextfield::init()
  {
    this->setClassID(CL_GLGUI_TEXTFIELD, "GLGuiTextfield");

    this->_text.setParent2D(this);
    this->_text.setRelCoor2D(4,4);
    this->_text.setFont("fonts/final_frontier.ttf", 20);
    this->_text.setLineWidth(400);
    this->_text.setColor(foregroundColor());
    this->_text.setVisibility(false);
    this->_changedTextColor = Color::white;
    this->resize();
  }

  /**
  * @brief sets the Text of the Text
  * @param text The new Text.
   */
  void GLGuiTextfield::setText(const std::string& text)
  {
    this->_text.setText(text);
    this->changedText();
  }

  /**
   * @brief appends text to the Text
   * @param appendText the Text to append
   */
  void GLGuiTextfield::append(const std::string& appendText)
  {
    this->_text.append(appendText);
    this->changedText();
  }


  /**
   * @brief appends a Character to the Text
   * @param character the Character to append.
   */
  void GLGuiTextfield::appendCharacter(char character)
  {
    this->_text.appendCharacter(character);
    this->changedText();
  }


  /**
   * @brief Removes Characters from the Text
   * @param chars The count of characters to remove
   */
  void GLGuiTextfield::removeCharacters(unsigned int chars)
  {
    this->_text.removeCharacters(chars);
    this->changedText();
  }

  void GLGuiTextfield::clear()
  {
    this->_text.clear();
    this->changedText();
  }

  /**
  * @brief If the Text has been changed this function is called.
  *
  * This Function also emits the Signal textChanged.
   */
  void GLGuiTextfield::changedText()
  {
    this->resize();
    this->setFrontColor(_changedTextColor, true);
    emit(this->textChanged(this->_text.text()));
  }

  void GLGuiTextfield::setChangedTextColor(const Color& color)
  {
    this->_changedTextColor = color;
  }

  /**
   * @brief Resizes the Widget to the new Size-constraints.
   */
  void GLGuiTextfield::resize()
  {
    this->_text.setRelCoor2D(borderLeft(), borderTop());
    this->setSize2D( this->_text.getSize2D() + Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));
    //this->_text.setLineWidth(this->size2D);
    GLGuiWidget::resize();
    /*    this->frontRect().setTopLeft(borderLeft(), borderTop());
    this->frontRect().setSize(this->getSize2D() - Vector2D(borderLeft() + borderRight(), borderTop() + borderBottom()));*/
  }

  void GLGuiTextfield::updateFrontColor()
  {
    this->_text.setColor(foregroundColor());
  }

  void GLGuiTextfield::hiding()
  {
    this->_text.setVisibility(false);
  }

  void GLGuiTextfield::showing()
  {
    this->_text.setVisibility(true);
  }



  /**
   * draws the GLGuiTextfield
   */
  void GLGuiTextfield::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    //     this->frontMaterial().select();
    //     GLGuiWidget::drawRect(this->frontRect());

    this->endDraw();
  }
}
