/**
 * @file rain_effect.h
 * Generates rain using the particle engine
*/

#ifndef _RAIN_EFFECT
#define _RAIN_EFFECT

#include "weather_effect.h"

#include "vector.h"
#include "vector2D.h"
#include <string>

#include "particle_system.h"

class SparkParticles;
class PlainEmitter;
class LightManager;
class CloudEffect;

#include "sound_buffer.h"
#include "sound_source.h"

class RainEffect : public WeatherEffect
{
public:
  RainEffect(const TiXmlElement* root = NULL);
  virtual ~RainEffect();

  virtual void loadParams(const TiXmlElement* root);

  virtual void init();

  virtual void activate();
  virtual void deactivate();

  inline void activateRain()
  {
    this->activate();
  }

  inline void deactivateRain()
  {
    this->deactivate();
  }

  virtual void tick(float dt);

  void startRaining();
  void stopRaining();

  void hideRain();

  inline void setRainCoord(float x, float y, float z)
  {
    this->rainCoord = Vector(x, y, z);
  }
  inline void setRainSize(float x, float y)
  {
    this->rainSize = Vector2D(x, y);
  }
  inline void setRainRate(float rate)
  {
    this->rainRate = rate;
  }
  inline void setRainVelocity(float velocity)
  {
    this->rainVelocity = -velocity;
  }
  inline void setRainLife(float life)
  {
    this->rainLife = life;
  }
  inline void setRainWind(int force)
  {
    this->rainWindForce = force;
  }

  inline void setRainFadeIn(float fadein)
  {
    this->rainFadeInDuration = fadein;
  }
  inline void setRainFadeOut(float fadeout)
  {
    this->rainFadeOutDuration = fadeout;
  }

  inline void setCloudColor(float colorX, float colorY, float colorZ)
  {
    this->cloudColor = Vector(colorX, colorY, colorZ);
  }
  inline void setSkyColor(float colorX, float colorY, float colorZ)
  {
    this->skyColor = Vector(colorX, colorY, colorZ);
  }

  inline void setRainOption(const std::string& option)
  {
    if (option == "moverain")
      this->rainMove = true;
    if (option == "activate")
      this->rainActivate = true;
  }


private:
  static SparkParticles*      rainParticles;
  ParticleEmitter*            emitter;

  float                       localTimer;

  GLfloat                     rainFadeInDuration;
  GLfloat                     rainFadeOutDuration;
  bool                        rainFadeInActivate;
  bool                        rainFadeOutActivate;

  Vector                      rainCoord;
  Vector2D                    rainSize;
  GLfloat                     rainRate;
  GLfloat                     rainVelocity;
  GLfloat                     rainLife;
  GLfloat                     rainMaxParticles;
  int                         rainWindForce;
  bool                        rainMove;
  bool                        rainActivate;

  OrxSound::SoundSource       soundSource;
  OrxSound::SoundBuffer*      rainBuffer;
  OrxSound::SoundBuffer*      windBuffer;

  float                       soundRainVolume;

  Vector oldSkyColor;
  Vector oldCloudColor;
  Vector skyColor;
  Vector cloudColor;

};

#endif  /* _RAIN_EFFECT */
