/**
* @file lightning_effect.h
*/

#ifndef _LIGHTNING_EFFECT
#define _LIGHTNING_EFFECT

#include "vector.h"
#include "vector2D.h"

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"

class Billboard;
class Light;

class LightningEffect : public WeatherEffect {
public:
    LightningEffect(const TiXmlElement* root = NULL);
    virtual ~LightningEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual void init();

    virtual void activate();
    virtual void deactivate();

    inline  void activateLightning() {
        this->activate();
    }
    inline  void deactivateLightning() {
        this->deactivate();
    }

    virtual void tick(float dt);

    void coord(float x, float y, float z);
    void setFlashSize(float width, float height, float seedWidth, float seedHeight);

    inline void setLightningOption(const std::string& option) {
        if (option == "activate")
            this->lightningActivate = true;
        if (option == "movelightning")
            this->lightningMove = true;
    }

    inline void setFlashFrequency(float baseFrequency, float seedTime) {
        this->flashFrequencyBase = baseFrequency;
        this->flashFrequency = baseFrequency;
        this->flashFrequencySeed = seedTime;
    }

    inline void setFlashConstTime(float holdTime) {
        this->flashHoldTime = holdTime;
    }

    inline void setFlashRisingTime(float flashRisingTime) {
        if(flashRisingTime > this->flashHoldTime)
            this->flashRisingTime = this->flashHoldTime * 0.5;
        else
            this->flashRisingTime = flashRisingTime;
    }

    inline void setFlashSeed(float seedX, float seedZ) {
        this->seedX = seedX;
        this->seedZ = seedZ;
    }


private:

    void newCoordinates();
    void setTexture();
    void switchTexture();

    Billboard* thunderBolt[4];
    bool thunderTextureA;

    bool lightningActivate;
    bool lightningMove;

    float flashFrequency;
    float flashFrequencyBase;
    float flashHoldTime;
    float flashRisingTime;

    float time;

    float width;
    float height;
    float seedWidth;
    float seedHeight;

    float seedX;
    float seedZ;
    float flashFrequencySeed;

    float mainPosX;
    float mainPosY;
    float mainPosZ;

    Vector origSkyColor;
    Vector cameraCoor;

    Light* flashLight;

    OrxSound::SoundSource    soundSource;
    OrxSound::SoundBuffer*   thunderBuffer;

};

#endif  /* _LIGHTNING_EFFECT */
