/**
 * @file cloud_effect.h
 * Create clouds
*/

#ifndef _CLOUD_EFFECT
#define _CLOUD_EFFECT

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"

#include "skydome.h"
#include "material.h"
#include "shader.h"

#define MAXB 0x100
#define N 0x1000
#define NP 12   /* 2^N */
#define NM 0xfff

#define s_curve(t) ( t * t * (3. - 2. * t) )
#define lerp(t, a, b) ( a + t * (b - a) )
#define setup(i,b0,b1,r0,r1)\
        t = vec[i] + N;\
        b0 = ((int)t) & BM;\
        b1 = (b0+1) & BM;\
        r0 = t - (int)t;\
        r1 = r0 - 1.;
#define at2(rx,ry) ( rx * q[0] + ry * q[1] )
#define at3(rx,ry,rz) ( rx * q[0] + ry * q[1] + rz * q[2] )

// FORWARD DECLARATION
template <class T>
class tAnimation;

class CloudEffect : public WeatherEffect {

public:

    CloudEffect(const TiXmlElement* root = NULL);
    virtual ~CloudEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual void init();

    virtual void activate();
    virtual void deactivate();

    void activateCloud() {
        this->activate();
    }
    void deactivateCloud() {
        this->deactivate();
    }

    void setCloudOption(const std::string& option) {
        if (option == "activate")
            this->cloudActivate = true;
    }

    void setAnimationSpeed(float speed) {
        this->animationSpeed = speed;
    }

    void setCloudScale(float scale) {
        this->scale = scale;
    }

    void setCloudColor(float colorX, float colorY, float colorZ) {
        this->cloudColor = Vector(colorX, colorY, colorZ);
    }

    void setSkyColor(float colorX, float colorY, float colorZ) {
        this->skyColor = Vector(colorX, colorY, colorZ);
    }

    void setPlanetRadius(float planetRadius) {
        this->planetRadius = planetRadius;
    }

    void setAtmosphericRadius(float atmosphericRadius) {
        this->atmosphericRadius = atmosphericRadius;
    }

    void setDivisions(int divs) {
        this->divs = divs;
    }

    virtual void draw() const;
    virtual void tick(float dt);

    static void changeSkyColor(Vector color, float time);
    static void changeCloudColor(Vector color, float time);

    void setColorSkyX(float color);
    void setColorSkyY(float color);
    void setColorSkyZ(float color);
    void setColorCloudX(float color);
    void setColorCloudY(float color);
    void setColorCloudZ(float color);

    static Vector cloudColor;
    static Vector skyColor;

    void make3DNoiseTexture();
    void initNoise();
    void SetNoiseFrequency(int frequency);
    double noise3(double vec[3]);
    void normalize2(double v[2]);
    void normalize3(double v[3]);

    void generateSkyPlane(int divisions, float planetRadius, float atmosphereRadius,
                          float hTile, float vTile);

    void shellSkyColor(float colorX, float colorY, float colorZ, float time);
    void shellCloudColor(float colorX, float colorY, float colorZ, float time);

    static void flashSky(float time);

private:

    bool                    cloudActivate;
    float                   animationSpeed;

    static Vector           newSkyColor;
    static Vector           newCloudColor;

    // Material             cloudMaterial;
    Skydome*                 skydome;

    tAnimation<CloudEffect>*  skyColorFadeX;
    tAnimation<CloudEffect>*  skyColorFadeY;
    tAnimation<CloudEffect>*  skyColorFadeZ;
    tAnimation<CloudEffect>*  cloudColorFadeX;
    tAnimation<CloudEffect>*  cloudColorFadeY;
    tAnimation<CloudEffect>*  cloudColorFadeZ;
    static bool fadeSky;
    static bool fadeCloud;
    static float fadeTime;

    // SHADER STUFF
    Shader*          shader;
    Shader::Uniform* offset;
    Shader::Uniform* skycolor;
    Shader::Uniform* cloudcolor;
    float            offsetZ;
    float            scale;
    float            planetRadius;
    float            atmosphericRadius;
    int              divs;

    // NOISE STUFF
    int              noise3DTexSize;
    GLuint           noise3DTexName;
    GLubyte          *noise3DTexPtr;

    int              p[MAXB + MAXB + 2];
    double           g3[MAXB + MAXB + 2][3];
    double           g2[MAXB + MAXB + 2][2];
    double           g1[MAXB + MAXB + 2];

    int              start;
    int              B;
    int              BM;

    static bool      flashSkyActivate;
    static float     localTimer;
    static float     flashTime;

};

#endif  /* _CLOUD_EFFECT */
