/*!
 * @file glgui_bar.h
 * The gl_ widget of th openglGUI
 *
 */

#ifndef _GLGUI_BAR_H
#define _GLGUI_BAR_H

#include "glgui_widget.h"


namespace OrxGui
{


  //! This is Bar part of the openglGUI class
  /**
   * The Bar shows the part value.
   */
  class GLGuiBar : public GLGuiWidget
  {

  public:
    GLGuiBar();
    virtual ~GLGuiBar();

    void setValue(float value);
    void setMinimum(float minimum);
    void setMaximum(float maximum);
    void setRange(float minimum, float maximum);

    float getValue() const { return this->_value; };
    float getMinimum() const { return this->_minimum; };
    float getMaximum() const { return this->_maximum; };

    virtual void update() { };
    virtual void draw() const;

  protected:
    virtual void resize();
    virtual void updateFrontColor();

  private:
    void init();

  private:
    float         _value;

    Rect2D        _frontRect;

    float         _minimum;
    float         _maximum;
  };
}
#endif /* _GLGUI__H */
