/*!
 * @file glgui_energywidget.h
 * @brief Definition of an EnergyWidget, that displays a bar and a Text
*/

#ifndef _GLGUI_ENERGY_WIDGET_H
#define _GLGUI_ENERGY_WIDGET_H

#include "glgui_box.h"
#include "glgui_bar.h"
#include "glgui_text.h"

namespace OrxGui
{

  //! A class for ...
  class GLGuiEnergyWidget : public GLGuiBox
  {

  public:
    GLGuiEnergyWidget();
    virtual ~GLGuiEnergyWidget();

    void setMaximum(float max);
    void setValue(float value);

  protected:
    //virtual void resize();
    virtual void showing();
    virtual void hiding();

  private:
    GLGuiBar                bar;
    GLGuiText               text;

  };
}
#endif /* _GLGUI_ENERGY_WIDGET_H */
