/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "glgui_energywidget.h"

namespace OrxGui
{
  /**
   * @brief standard constructor
   * @todo this constructor is not jet implemented - do it
  */
  GLGuiEnergyWidget::GLGuiEnergyWidget ()
  {
    //   this->setClassID(CL_PROTO_ID, "GLGuiEnergyWidget");

    this->pack(&this->text);
    this->pack(&this->bar);
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiEnergyWidget::~GLGuiEnergyWidget ()
  {
    // delete what has to be deleted here
  }



  void GLGuiEnergyWidget::setMaximum(float max)
  {
    this->bar.setMaximum(max);
  }

  void GLGuiEnergyWidget::setValue(float value)
  {
    MultiType val = value;

    this->bar.setValue(value);
    this->text.setText(val.getString());
  }


  void GLGuiEnergyWidget::showing()
  {
    this->text.show();
    this->bar.show();
  }

  void GLGuiEnergyWidget::hiding()
  {
    this->text.hide();
    this->bar.hide();
  }



}
