/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_bar.h"


namespace OrxGui
{

  /**
   * @brief standard constructor
  */
  GLGuiBar::GLGuiBar ()
  {
    this->init();

  }


  /**
   * @brief standard deconstructor
   */
  GLGuiBar::~GLGuiBar()
  {
  }

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiBar::init()
  {
    this->setClassID(CL_GLGUI_BAR, "GLGuiBar");

    this->setFrontColor(Color(1,1,1));

    this->setSize2D(50, 10);

    this->value = 0.5f;
    this->minimum = 0.0f;
    this->maximum = 1.0f;
  }

  void GLGuiBar::resize()
  {
    GLGuiWidget::resize();


  }


  /**
   * @brief draws the GLGuiBar
   */
  void GLGuiBar::draw() const
  {
    printf("BAR\n");
    this->beginDraw();
    GLGuiWidget::draw();

    this->endDraw();
  }
}
