#ifndef _REPAIR_STATION_H
#define _REPAIR_STATION_H

#include "world_entity.h"

#include "md2/md2Model.h"

class TiXmlElement;


//! animation names enumeration
typedef enum RepairStationAnimType
{
  REPAIR_CYCLE01 = 0,
  REPAIR_CYCLE02,
  REPAIR_CYCLE03,
  REPAIR_CYCLE04,
  REPAIR_CYCLE05,
  REPAIR_CYCLE06,
  REPAIR_CYCLE07,
  REPAIR_CYCLE08,

  REPAIR_MAX_ANIMATIONS
};


class RepairStation : public WorldEntity
{
  public:
    RepairStation ();
    RepairStation(const TiXmlElement* root);
    virtual ~RepairStation ();

    virtual void loadParams(const TiXmlElement* root);

    void setActionRadius(float radius) { this->actionRadius = radius; }
    void setScale(float scale) { this->scale = scale; }

    void activate();
    void deactivate();
    void toggleRotation();

    virtual void tick (float time);


  private:
    void setAnimation(int animNum, int playbackMode = 0);


  private:
    float          scale;             //!< the scale of the model

    static sAnim   animationList[8];  //!< list of the animations

    int            animationCurrent;  //!< number of the current animation
    int            animationStep;     //!< the incrementation step of the animation

};

#endif /* _REPAIR_STATION_H */
