

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "interactive_model.h"


#include "repair_station.h"
#include "class_list.h"


using namespace std;


CREATE_FACTORY(RepairStation, CL_DOOR);



//! list of all different animations a std md2model supports
// sAnim RepairStation::animationList[2] =
// {
//  // begin, end, fps, interruptable
//   {   0,  10,  30,  0 },   //!< OPEN
//   {   10, 20,  30,  0 }    //!< CLOSE
// };


sAnim RepairStation::animationList[8] =
{
 // begin, end, fps, interruptable
  {   0,  12,  30,  0 },   //!< CYCLE01
  {   12, 24,  30,  0 },   //!< CYCLE02
  {   24, 40,  30,  0 },   //!< CYCLE03
  {   40, 55,  30,  0 },   //!< CYCLE04
  {   55, 68,  30,  0 },   //!< CYCLE05
  {   68, 81,  30,  0 },   //!< CYCLE06
  {   81, 89,  30,  0 },   //!< CYCLE07
  {   89, 99,  30,  0 }    //!< CYCLE08
};



RepairStation::RepairStation ()
{
  this->init();
}


RepairStation::RepairStation(const TiXmlElement* root)
{

  this->setClassID(CL_DOOR, "RepairStation");
  this->scale = 1.0f;

  if( root != NULL)
    this->loadParams(root);

  this->toList(OM_COMMON);
  this->bLocked = false;

  this->loadMD2Texture("maps/doors.jpg");
  this->loadModel("models/creatures/doors.md2", this->scale);

  this->setAnimation(DOOR_CLOSE, MD2_ANIM_ONCE);
}


RepairStation::~RepairStation ()
{}



/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void RepairStation::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "action-radius", this, RepairStation, setActionRadius)
      .describe("sets the action radius of the door")
      .defaultValues(3.0);
  LoadParam(root, "scale", this, RepairStation, setScale)
      .describe("sets the scale of the door")
      .defaultValues(1.0);
}


/**
 * sets the animatin of this entity
 */
void  RepairStation::setAnimation(int animNum, int playbackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationList[animNum].firstFrame,
                                                         animationList[animNum].lastFrame,
                                                         animationList[animNum].fps,
                                                         animationList[animNum].bStoppable,
                                                         playbackMode);
}





void RepairStation::activate()
{}

void RepairStation::deactivate()
{}

void RepairStation::toggleRotation()
{}


/**
 * ticks the door
 * @param time: time since last tick
 */
void RepairStation::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->tick(time);


}




