
/*!
 * @file generic_npc.h
 * generic npc object
 */

#ifndef _GENERIC_ENTITY_H
#define _GENERIC_ENTITY_H

#include "npc.h"


#include "sound_source.h"

namespace OrxSound{ class SoundSource; }
namespace OrxSound{ class SoundBuffer; }

class TiXmlElement;
class Animation3D;


class GenericNPC : public NPC
{


 public:
  GenericNPC(const TiXmlElement* root = NULL);
  virtual ~GenericNPC ();

  virtual void loadParams(const TiXmlElement* root);

  void setAnimation(int animationIndex, int animPlaybackMode);
  /** sets the sound volume to @param vol: volume of the sound */
  inline void setVolume(float vol) { this->soundVolume = vol; }



  bool finalGoalReached() const { return this->behaviourList.empty(); };

  /* npc controlling functions to be Queued */
  /* walking functions */
  void walkTo(const Vector& coordinate);
  void walkTo(float x, float y, float z);

  /* running functions */
  void runTo(const Vector& coordinate);
  void runTo(float x, float y, float z);

  /* couching functinos */
  void crouchTo(const Vector& coordinate);
  void crouchTo(float x, float y, float z);

  /* stopping the movement */
  void stop();
  void nextStep();

  /* some oriantation functions */
  void lookAt(WorldEntity* worldEntity);
  void turnTo(float qu, float qx, float qy, float qz);
  void turnTo(float degreeInY);

  /* talking funcitons*/
  void talkTo(WorldEntity* worldEntity, int dialogNr);

  /* shooting functions */
  void shootAt(WorldEntity* entity);


  /* some generic control funtions */
  void playAnimation(int animationIndex, int animPlaybackMode);
  void playSound(std::string filename);
  void playSound(int i);

  virtual void tick (float time);


  void destroy();

  private:
    void init();


 private:

   typedef enum {
    Walk,
    Run,
    Crouch,
    Jump,
    TurnTo,
    LookAt,
    TalkTo,

    Shoot,


   } AnimType;

   typedef struct Anim
   {
     Vector        v;
     Quaternion    q;


     WorldEntity*  entity;
     float         speed;


     AnimType      type;
   };
   typedef std::list<GenericNPC::Anim>     genNPCAnimList;



   OrxSound::SoundSource                   soundSource;
   OrxSound::SoundBuffer*                  soundBuffer;
   float                                   soundVolume;

   std::list<GenericNPC::Anim>             behaviourList;
   Vector                                  destCoor;
   Quaternion                              destDir;

   Animation3D*                            currentAnim;
   float                                   time;          //!< Duration of the action
};

#endif /* _GENERIC_ENTITY_H */
