

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "generic_npc.h"


#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "interactive_model.h"
#include "md2/md2Model.h"

#include "sound_buffer.h"

#include "loading/resource_manager.h"


CREATE_FACTORY(GenericNPC, CL_GENERIC_NPC);

#include "script_class.h"
CREATE_SCRIPTABLE_CLASS(GenericNPC, CL_GENERIC_NPC,
                       // Move
                        addMethod("walkTo", ExecutorLua3<GenericNPC,float,float,float>(&GenericNPC::walkTo))
                        ->addMethod("turnTo", ExecutorLua1<GenericNPC,float>(&GenericNPC::turnTo))
                       // Display
                        ->addMethod("hide", ExecutorLua0<WorldEntity>(&WorldEntity::hide))
                        ->addMethod("unhide", ExecutorLua0<WorldEntity>(&WorldEntity::unhide))
                       // Coordinates
                        ->addMethod("getAbsCoorX", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorX))
                        ->addMethod("getAbsCoorY", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorY))
                        ->addMethod("getAbsCoorZ", ExecutorLua0ret<PNode, float>(&PNode::getAbsCoorZ))
                        ->addMethod("setAbsCoor", ExecutorLua3<PNode,float,float,float>(&PNode::setAbsCoor))
                        ->addMethod("setAbsDir", ExecutorLua4<PNode,float,float,float,float>(&PNode::setAbsDir))

                       );



/**
 * constructor
 */
GenericNPC::GenericNPC(const TiXmlElement* root)
  : NPC(root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}


/**
 * deconstructor
 */
GenericNPC::~GenericNPC ()
{
}


/**
 * initializing the npc enity
 */
void GenericNPC::init()
{
  this->setClassID(CL_GENERIC_NPC, "GenericNPC");
  this->toList(OM_GROUP_00);

  if (this->soundBuffer != NULL)
    ResourceManager::getInstance()->unload(this->soundBuffer);
  this->soundBuffer = (OrxSound::SoundBuffer*)ResourceManager::getInstance()->load("sound/rain.wav", WAV);

  time = 30.0f;
  // collision reaction registration
//   this->subscribeReaction(CREngine::CR_PHYSICS_GROUND_WALK, CL_BSP_ENTITY);
}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void GenericNPC::loadParams(const TiXmlElement* root)
{
  NPC::loadParams(root);

}


/**
 * sets the animation of this npc
 * @param anumationIndex: the animation index
 * @param anumPlaybackMode: the playback mode
 */
void GenericNPC::setAnimation(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationIndex, animPlaybackMode);
}


/**
 * sets the animation of this npc
 * @param anumationIndex: the animation index
 * @param anumPlaybackMode: the playback mode
 */
void GenericNPC::playAnimation(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationIndex, animPlaybackMode);

}


/**
 * play a sound
 * @param filename: name of the file
 */
void GenericNPC::playSound(std::string filename)
{

}



/**
 * stops the generic animation
 */
void GenericNPC::stop()
{

}


void GenericNPC::walkTo(const Vector& coordinate)
{
  GenericNPC::Anim anim;
  anim.v = coordinate;
  anim.type = Walk;

  this->behaviourList.push_back(anim);
}

void GenericNPC::walkTo(float x, float y, float z)
{
  this->walkTo(Vector(x,y,z));

}

/* running functions */
void GenericNPC::runTo(const Vector& coordinate)
{
  GenericNPC::Anim anim;
  anim.v = coordinate;
  anim.type = Run;

  this->behaviourList.push_back(anim);
}

void GenericNPC::runTo(float x, float y, float z)
{
  this->runTo(Vector(x,y,z));
}

/* couching functinos */
void GenericNPC::crouchTo(const Vector& coordinate)
{
  GenericNPC::Anim anim;
  anim.v = coordinate;
  anim.type = Crouch;

  this->behaviourList.push_back(anim);
}
void GenericNPC::crouchTo(float x, float y, float z)
{
  this->crouchTo(Vector(x,y,z));
}



void GenericNPC::turnTo(float degreeInY)
{
  GenericNPC::Anim anim;
  anim.q = Quaternion(Vector(0,1,0), degreeInY);
  anim.type = TurnTo;

  this->behaviourList.push_back(anim);
}



/**
 * lookat a world entity
 * @param worldEntity: the worldentity to look at
 */
void GenericNPC::lookAt(WorldEntity* worldEntity)
{
  GenericNPC::Anim anim;
  anim.entity = worldEntity;
  anim.type = LookAt;

  this->behaviourList.push_back(anim);
}




/**
 * talk to a world entity and play a sound/music/voice
 * @param worldEntity: entity
 * @param dialogNr: sound nr to be played (from the xml load tags)
 */
void GenericNPC::talkTo(WorldEntity* worldEntity, int dialogNr)
{}


/**
 * world entity to shoot at if there is any weapon on the npc
 * @param entity: entity to shoot entity
 */
void GenericNPC::shootAt(WorldEntity* entity)
{}










/**
 * tick this world entity
 * @param time: time in seconds expirded since the last tick
 */
void GenericNPC::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->tick(time);


  if (!this->behaviourList.empty())
  {
    switch(this->behaviourList.front().type)
    {
      case Walk:
        break;
      case Run:
        break;
      case Crouch:
        break;
      case LookAt:
        break;
      case Shoot:
        break;

    }
  }

}



void GenericNPC::destroy()
{
  int randi = (int)(5.0f * (float)rand()/(float)RAND_MAX);

  if( randi == 1)
    this->setAnimation(DEATH_FALLBACK, MD2_ANIM_ONCE);
  else if( randi == 2)
    this->setAnimation(DEATH_FALLFORWARD, MD2_ANIM_ONCE);
  else if( randi == 3)
    this->setAnimation(DEATH_FALLBACKSLOW, MD2_ANIM_ONCE);
  else if( randi == 4)
    this->setAnimation(CROUCH_DEATH, MD2_ANIM_ONCE);
  else
    this->setAnimation(DEATH_FALLBACK, MD2_ANIM_ONCE);
}

