/*!
 * @file cr_object_damage.h
 *  Definition of a collision reaction: dealing damage to an object
 */

#ifndef _CR_PHYSICS_GROUND_WALK_H
#define _CR_PHYSICS_GROUND_WALK_H

#include "collision_reaction.h"


class Collision;

//! A class representing a reaction to a collision: dealing damage to an object
class CRPhysicsGroundWalk : public CollisionReaction
{
  public:
    CRPhysicsGroundWalk();
    virtual ~CRPhysicsGroundWalk();

    virtual void reactToCollision(Collision* collision);

    virtual void update(WorldEntity* entity);


  private:
    float        downspeed;
};

#endif /* _CR_PHYSICS_GROUND_WALK_H */
