/*!
 * @file collision_event.h
 *  Definition of a collision event
 */

#ifndef _COLLISION_EVENT_H
#define _COLLISION_EVENT_H

#include "vector.h"

#include "cr_defs.h"


class WorldEntity;
class BoundingVolume;
class Plane;



//! A class representing a simple collision
class CollisionEvent {

 public:
   CollisionEvent();
  virtual ~CollisionEvent();

  /** collides two WorldEntities @param entityA world entity A, @param entityB world entity B, @param bvA volume A @param bvB volumeB */
  inline void collide(int type, WorldEntity* entityA, WorldEntity* entityB, BoundingVolume* bvA, BoundingVolume* bvB)
  { this->collisionType = type; this->entityA = entityA; this->entityB = entityB; this->bvA = bvA; this->bvB = bvB; }
  /** collides two WorldEntities @param entity world entity , @param ground ground plane, @param position position on the ground */
  inline void collide(int type, WorldEntity* entity, WorldEntity* groundEntity, Vector normal, Vector position, bool bInWall)
  { this->collisionType = type; this->entityA = entity; this->entityB = groundEntity, this->groundNormal = normal; this->position = position; this->bInWall = bInWall; }


  /** @return CollisionEvent WorldEntity A */
  inline WorldEntity* getEntityA() const { return this->entityA; }
  /** @return CollisionEvent WorldEntity B */
  inline WorldEntity* getEntityB() const { return this->entityB; }
  /** @return Bounding Volume from EntityA */
  inline BoundingVolume* getBVA() const { return this->bvA; }
  /** @return Bounding Volume from EntityB */
  inline BoundingVolume* getBVB() const { return this->bvB; }

  /** @return ground plane if collided with bsp model */
  inline Vector getGroundNormal() { return this->groundNormal; }

  /** @return position of the position, only accurate if this is a collision with the ground!!! */
  inline Vector getCollisionPosition() { return this->position; }

  /** @return the type of the collision */
  inline int getType() { return this->collisionType; }

  /** @return true if the entity is in the wall */
  inline bool isInWall() { return this->bInWall; }


 private:
  WorldEntity*      entityA;                       //!< the collision body A
  WorldEntity*      entityB;                       //!< the collision body B

  BoundingVolume*   bvA;                           //!< reference to the bounding volume A
  BoundingVolume*   bvB;                           //!< reference to the bounding volume B

  Vector            groundNormal;                  //!< the ground plane with which it collides (only for bsp-model collisions
  Vector            position;                      //!< position of the collision on the ground plane

  bool              bInWall;                       //!< true if is in wall
  int               collisionType;                 //!< collision type
};

#endif /* _COLLISION_EVENT_H */
