
/*!
 * @file generic_npc.h
 * generic npc object
 */

#ifndef _GENERIC_ENTITY_H
#define _GENERIC_ENTITY_H

#include "npc.h"

#include <string>

#include "sound_source.h"

#include "vector.h"
#include "quaternion.h"


namespace OrxSound{ class SoundSource; }
namespace OrxSound{ class SoundBuffer; }

class TiXmlElement;
class Animation3D;


class GenericNPC : public NPC
{
 public:
  GenericNPC(const TiXmlElement* root);
  virtual ~GenericNPC ();

  void init();
  virtual void loadParams(const TiXmlElement* root);

  void setAnimation(int animationIndex, int animPlaybackMode);
  /** sets the sound volume to @param vol: volume of the sound */
  inline void setVolume(float vol) { this->soundVolume = vol; }

  void playAnimation(int animationIndex, int animPlaybackMode);

  void playSound(std::string filename);
  void playSound(int i);

  float lookAt(WorldEntity* worldEntity);

  float walkTo(const Vector& coordinate, const Quaternion& dir);
  float walkTo(float x, float y, float z, float qu, float qx, float qy, float qz);
  float walkTo(float x, float y, float qu, float qx, float qy, float qz);

  float runTo(const Vector& coordinate, const Quaternion& dir);
  float runTo(float x, float y, float z, float qu, float qx, float qy, float qz);
  float runTo(float x, float y, float qu, float qx, float qy, float qz);

  float crouchTo(const Vector& coordinate, const Quaternion& dir);
  float crouchTo(float x, float y, float z, float qu, float qx, float qy, float qz);
  float crouchTo(float x, float y, float qu, float qx, float qy, float qz);

  float talkTo(WorldEntity* worldEntity, int dialogNr);


  void destroy();

  virtual void tick (float time);


 private:
   OrxSound::SoundSource                   soundSource;
   OrxSound::SoundBuffer*                  soundBuffer;
   float                                   soundVolume;

   Vector                                  destCoor;
   Quaternion                              destDir;

   Animation3D*                            currentAnim;
};

#endif /* _GENERIC_ENTITY_H */
