

/*!
 * @file network_manager.h
 *  Main interface for the network module. Manages all the modules

 */

#ifndef _NETDEFS
#define _NETDEFS

#ifdef HAVE_SDL_NET_H
  #include <SDL_net.h>
#else
  #include <SDL/SDL_net.h>
#endif


#define MAX_CONNECTIONS 1000

#define NETWORK_FREQUENCY 66


typedef unsigned char byte;


typedef enum {
  NET_SERVER,
  NET_CLIENT
} NodeType;

typedef enum ConnectionType {
  NET_UDP = 0,
  NET_TCP
};


typedef enum {
  NET_UID_UNASSIGNED = -1,

  NET_UID_NUMBER
} UidType;

#endif /* _NETWORK_MANAGER */
