

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "executor/executor.h"
#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "kill.h"
#include "game_rules.h"

#include "test_entity.h"


#include "interactive_model.h"
#include "md2/md2Model.h"

#include "state.h"

using namespace std;


CREATE_FACTORY(TestEntity, CL_TEST_ENTITY);


TestEntity::TestEntity ()
{
  this->init();
  this->md2Model = new MD2Model("models/droidika.md2", "models/droideka.pcx");
}


//   this->md2Model = new MD2Model("models/tris.md2", "models/tris.pcx");
// this->md2Model = new MD2Model("models/goblin.md2", "maps/goblin.bmp");
//   this->obbTree = new OBBTree(4, (sVec3D*)this->md2Model->data->pVertices, this->md2Model->data->numVertices);


TestEntity::TestEntity(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


TestEntity::~TestEntity ()
{}



void TestEntity::init()
{
  this->setClassID(CL_TEST_ENTITY, "TestEntity");
  this->toList(OM_GROUP_00);

  this->lastCollided = NULL;
  this->bDeath = false;
}

/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void TestEntity::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "md2animation", this, TestEntity, setAnim)
      .describe("sets the animation of the md2 model")
      .defaultValues(1);

}


void  TestEntity::setAnim(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationIndex, animPlaybackMode);
}


void TestEntity::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->tick(time);

}


void TestEntity::collidesWith(WorldEntity* entity, const Vector& location)
{
  if( this->lastCollided != entity)
  {
    this->destroy();
    this->lastCollided = entity;

    if(State::getGameRules())
      State::getGameRules()->registerKill(Kill(entity, this));
  }
}



void TestEntity::destroy()
{
  if( this->bDeath)
    return;

  this->bDeath = true;
  int randi = (int)(5.0f * (float)rand()/(float)RAND_MAX);

  PRINTF(0)("randi = %i\n", randi);

  if( randi == 1)
    this->setAnim(DEATH_FALLBACK, MD2_ANIM_ONCE);
  else if( randi == 2)
    this->setAnim(DEATH_FALLFORWARD, MD2_ANIM_ONCE);
  else if( randi == 3)
    this->setAnim(DEATH_FALLBACKSLOW, MD2_ANIM_ONCE);
  else if( randi == 4)
    this->setAnim(CROUCH_DEATH, MD2_ANIM_ONCE);
  else
    this->setAnim(DEATH_FALLBACK, MD2_ANIM_ONCE);
}

