/*!
 * @file texture_data.h
 * @brief Contains the texture class, that handles the reading of Images into Texutre-files.
 */

#ifndef _TEXTURE_DATA_H
#define _TEXTURE_DATA_H

#include "base_object.h"

#include "glincl.h"
#include "count_pointer.h"

/* Forward Declaration */
struct SDL_Surface;


class TextureData
{
  public:
    TextureData();
    ~TextureData();

    inline GLuint getTexture() const { return this->texture; };
    /** @returns true if texture has alpha, false otherwise */
    inline bool hasAlpha() const  {return this->bAlpha; }
    /** @returns the stored image of this Texture */
    const SDL_Surface* const getStoredImage() const { return this->image; };

    bool loadSurface(SDL_Surface* surface, GLenum target = GL_TEXTURE_2D);

    bool rebuild();

    bool setSurface(SDL_Surface* newSurface);
    /** @returns true if the Surface has an Alpha Value. */
    bool setAlpha(bool hasAlpha) { this->bAlpha = hasAlpha; return this->bAlpha; };
    bool setTexture(GLuint texture);

  private:
    GLuint           texture;            //!< The Texture-ID of opengl from this Texture.
    bool             bAlpha;             //!< if the texture has an alpha channel.
    SDL_Surface*     image;              //!< The SDL_Surfce that stores the Texture on it.
};

typedef CountPointer<TextureData> TextureDataPointer;

#endif /* _TEXTURE_DATA_H */
