/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_IMPORTER

#include "font_data.h"

#include "debug.h"
#include "compiler.h"

#include "sdlincl.h"

/**
 * @brief creates a new Font Data.
 */
FontData::FontData()
{
  this->fontTTF = NULL;
  this->glyphArray = NULL;
}


/**
 * @brief Destructor of a Font
 *
 *  Frees Data, and deletes the fonts from GL
 */
FontData::~FontData()
{
  // deleting all Glyphs
  if (this->glyphArray != NULL)
  {
    for (int i = 0; i < FONT_HIGHEST_KNOWN_CHAR; i++)
    {
      if (this->glyphArray[i] != NULL)
        delete this->glyphArray[i];
    }
    delete[] this->glyphArray;
  }

  //! @todo check if we really do not need to delete the fastTextureID here.
  //   if (this->fastTextureID != 0)
  //     if(glIsTexture(this->fastTextureID))
  //       glDeleteTextures(1, &this->fastTextureID);

  // erease this font out of the memory.
  if (likely(this->fontTTF != NULL))
    TTF_CloseFont(this->fontTTF);
}


